/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParameter;
import org.apache.ignite.mxbean.MXBeanParametersNames;

@MXBeanDescription(value="MBean that provides access to Ignite transactions.")
public interface TransactionsMXBean {
    @MXBeanDescription(value="Returns or kills transactions matching the filter conditions.")
    public String getActiveTransactions(@MXBeanParameter(name="minDuration", description="Minimum duration (seconds).") Long var1, @MXBeanParameter(name="minSize", description="Minimum size.") Integer var2, @MXBeanParameter(name="prj", description="Projection (servers|clients).") String var3, @MXBeanParameter(name="consistentIds", description="Consistent ids (separated by comma).") String var4, @MXBeanParameter(name="xid", description="Transaction XID.") String var5, @MXBeanParameter(name="lbRegex", description="Label regexp.") String var6, @MXBeanParameter(name="limit", description="Limit a number of transactions collected on each node.") Integer var7, @MXBeanParameter(name="order", description="Order by DURATION|SIZE.") String var8, @MXBeanParameter(name="detailed", description="Show detailed description, otherwise only count.") boolean var9, @MXBeanParameter(name="kill", description="Kill matching transactions (be careful).") boolean var10);

    @MXBeanDescription(value="Kills transactions by the xid.")
    public void cancel(@MXBeanParameter(name="xid", description="Transaction XID.") String var1);

    @MXBeanDescription(value="Returns transaction timeout on partition map exchange in milliseconds.")
    public long getTxTimeoutOnPartitionMapExchange();

    @MXBeanDescription(value="Sets transaction timeout on partition map exchange in milliseconds.")
    public void setTxTimeoutOnPartitionMapExchange(@MXBeanParameter(name="timeout", description="Transaction timeout on partition map exchange in milliseconds.") long var1);

    @MXBeanDescription(value="Shows if dump requests from local node to near node are allowed, when long running transaction  is found. If allowed, the compute request to near node will be made to get thread dump of transaction owner thread.")
    public boolean getTxOwnerDumpRequestsAllowed();

    @MXBeanDescription(value="Shows if dump requests from local node to near node are allowed, when long running transaction  is found. If allowed, the compute request to near node will be made to get thread dump of transaction owner thread.")
    public void setTxOwnerDumpRequestsAllowed(@MXBeanParameter(name="allowed", description="Whether to allow.") boolean var1);

    @MXBeanDescription(value="Returns threshold timeout in milliseconds for long transactions, if transaction exceeds it, it will be dumped in log with information about how much time did it spent in system time (time while aquiring locks, preparing, commiting, etc.)and user time (time when client node runs some code while holding transaction). Returns 0 if not set. No transactions are dumped in log if this parameter is not set.")
    public long getLongTransactionTimeDumpThreshold();

    @MXBeanDescription(value="Sets threshold timeout in milliseconds for long transactions, if transaction exceeds it, it will be dumped in log with information about how much time did it spent in system time (time while aquiring locks, preparing, commiting, etc.) and user time (time when client node runs some code while holding transaction). Can be set to 0 - no transactions will be dumped in log in this case.")
    public void setLongTransactionTimeDumpThreshold(@MXBeanParameter(name="threshold", description="Threshold timeout.") long var1);

    @MXBeanDescription(value="Returns the coefficient for samples of completed transactions that will be dumped in log.")
    public double getTransactionTimeDumpSamplesCoefficient();

    @MXBeanDescription(value="Sets the coefficient for samples of completed transactions that will be dumped in log.")
    public void setTransactionTimeDumpSamplesCoefficient(@MXBeanParameter(name="coefficient", description="Samples coefficient.") double var1);

    @MXBeanDescription(value="Returns the limit of samples of completed transactions that will be dumped in log per second, if {@link #getTransactionTimeDumpSamplesCoefficient} is above <code>0.0</code>. Must be integer value greater than <code>0</code>.")
    public int getTransactionTimeDumpSamplesPerSecondLimit();

    @MXBeanDescription(value="Sets the limit of samples of completed transactions that will be dumped in log per second, if {@link #getTransactionTimeDumpSamplesCoefficient} is above <code>0.0</code>. Must be integer value greater than <code>0</code>.")
    public void setTransactionTimeDumpSamplesPerSecondLimit(@MXBeanParameter(name="limit", description="Samples per second limit.") int var1);

    @MXBeanDescription(value="Setting a timeout (in millis) for printing long-running transactions as well as transactions that cannot receive locks for all their keys for a long time. Set less than or equal {@code 0} to disable.")
    public void setLongOperationsDumpTimeout(@MXBeanParameter(name="timeout", description="Long operations dump timeout.") long var1);

    @MXBeanDescription(value="Returns a timeout (in millis) for printing long-running transactions as well as transactions that cannot receive locks for all their keys for a long time. Returns {@code 0} or less if not set.")
    public long getLongOperationsDumpTimeout();

    @MXBeanParametersNames(value={"timeout"})
    @MXBeanDescription(value="Timeout interval (in millis) for printing tx key contention queue size info. Each transaction besides OPTIMISTIC SERIALIZABLE capture locks on all enlisted keys, for some reasons per key lock queue may rise. This property sets the interval during which keys and appropriate queue size statistics has been collected.")
    public void setTxKeyCollisionsInterval(int var1);

    @MXBeanDescription(value="Returns a timeout (in millis) for printing tx key contention queue size info. Each transaction besides OPTIMISTIC SERIALIZABLE capture locks on all enlisted keys, for some reasons per key lock queue may rise. Returns the interval during which keys and appropriate queue size statistics has been collected.")
    public int getTxKeyCollisionsInterval();
}

