/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class Dump
implements Command {
    private String pathKey = "path";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String path = (String)ctx.get(this.pathKey);
        PrintWriter out = CommandHelper.getOutput(ctx);
        this.dump(out, CommandHelper.getNode(ctx, path));
        return false;
    }

    public void dump(PrintWriter out, Node n) throws RepositoryException {
        out.println(n.getPath());
        PropertyIterator pit = n.getProperties();
        while (pit.hasNext()) {
            Property p = pit.nextProperty();
            out.print(p.getPath() + "=");
            if (p.getDefinition().isMultiple()) {
                Value[] values = p.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        out.println(",");
                    }
                    out.println(values[i].getString());
                }
            } else {
                out.print(p.getString());
            }
            out.println();
        }
        NodeIterator nit = n.getNodes();
        while (nit.hasNext()) {
            Node cn = nit.nextNode();
            this.dump(out, cn);
        }
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String pathKey) {
        this.pathKey = pathKey;
    }
}

