/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.roaringbitmap.longlong;

import java.io.DataOutput;
import java.io.IOException;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.apache.pulsar.shade.org.roaringbitmap.longlong.LongConsumer;
import org.apache.pulsar.shade.org.roaringbitmap.longlong.LongIterator;

public interface ImmutableLongBitmapDataProvider {
    public boolean contains(long var1);

    public long getLongCardinality();

    public void forEach(LongConsumer var1);

    public LongIterator getLongIterator();

    public LongIterator getReverseLongIterator();

    default public LongStream stream() {
        int characteristics = 85;
        Spliterator.OfLong x = Spliterators.spliterator(new RoaringOfLong(this.getLongIterator()), this.getLongCardinality(), characteristics);
        return StreamSupport.longStream(x, false);
    }

    default public LongStream reverseStream() {
        int characteristics = 81;
        Spliterator.OfLong x = Spliterators.spliterator(new RoaringOfLong(this.getLongIterator()), this.getLongCardinality(), characteristics);
        return StreamSupport.longStream(x, false);
    }

    public int getSizeInBytes();

    public long getLongSizeInBytes();

    public boolean isEmpty();

    public ImmutableLongBitmapDataProvider limit(long var1);

    public long rankLong(long var1);

    public long select(long var1);

    public long first();

    public long last();

    public void serialize(DataOutput var1) throws IOException;

    public long serializedSizeInBytes();

    public long[] toArray();

    public static final class RoaringOfLong
    implements PrimitiveIterator.OfLong {
        private final LongIterator iterator;

        public RoaringOfLong(LongIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public long nextLong() {
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

