/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface PrepareRequest
extends Request {
    public static final GenericType<PreparedStatement> SYNC = GenericType.of(PreparedStatement.class);
    public static final GenericType<CompletionStage<PreparedStatement>> ASYNC = new GenericType<CompletionStage<PreparedStatement>>(){};

    @NonNull
    public String getQuery();

    @Override
    @NonNull
    default public Boolean isIdempotent() {
        return true;
    }

    @Nullable
    public String getExecutionProfileNameForBoundStatements();

    @Nullable
    public DriverExecutionProfile getExecutionProfileForBoundStatements();

    public CqlIdentifier getRoutingKeyspaceForBoundStatements();

    public ByteBuffer getRoutingKeyForBoundStatements();

    public Token getRoutingTokenForBoundStatements();

    @NonNull
    public Map<String, ByteBuffer> getCustomPayloadForBoundStatements();

    @Nullable
    public Boolean areBoundStatementsIdempotent();

    @Nullable
    public Duration getTimeoutForBoundStatements();

    public ByteBuffer getPagingStateForBoundStatements();

    public int getPageSizeForBoundStatements();

    @Nullable
    public ConsistencyLevel getConsistencyLevelForBoundStatements();

    @Nullable
    public ConsistencyLevel getSerialConsistencyLevelForBoundStatements();

    public boolean areBoundStatementsTracing();
}

