/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpModifier;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.main.VarFinder;

public class LeftJoinClassifier {
    public static boolean print = false;

    public static boolean isLinear(OpLeftJoin op) {
        return LeftJoinClassifier.isLinear(op.getLeft(), op.getRight());
    }

    public static boolean isLinear(Op left, Op right) {
        boolean b4;
        left = LeftJoinClassifier.effectiveOp(left);
        if ((right = LeftJoinClassifier.effectiveOp(right)) instanceof OpModifier) {
            return false;
        }
        if (right instanceof OpLateral) {
            return false;
        }
        Set<Var> leftVars = OpVars.visibleVars(left);
        if (print) {
            System.err.println("Left");
            System.err.println("  Visible: " + String.valueOf(leftVars));
        }
        if (print) {
            VarFinder vfLeft = VarFinder.process(left);
            System.err.println("Left");
            vfLeft.print(System.err);
        }
        VarFinder vf = VarFinder.process(right);
        if (print) {
            System.err.println("Right");
            vf.print(System.err);
        }
        if (!vf.getFilterOnly().isEmpty()) {
            if (print) {
                System.err.println("LJ: Case 1 (true=ok) - false");
            }
            return false;
        }
        if (print) {
            System.err.println("LJ: Case 1 (true=ok)  - true");
        }
        Set<Var> optRight = vf.getOpt();
        Set<Var> fixedRight = vf.getFixed();
        Set<Var> filterVarsRight = vf.getFilter();
        Set<Var> assignVarsRight = vf.getAssign();
        boolean b2 = SetUtils.intersectionP(leftVars, optRight);
        if (print) {
            System.err.println("LJ: Case 2 (false=ok) - " + b2);
        }
        boolean b3 = SetUtils.intersectionP(leftVars, filterVarsRight);
        if (print) {
            System.err.println("LJ: Case 3 (false=ok) - " + b3);
        }
        HashSet<Var> unsafeAssign = new HashSet<Var>(assignVarsRight);
        unsafeAssign.removeAll(fixedRight);
        boolean bl = b4 = unsafeAssign.size() > 0;
        if (print) {
            System.err.println("LJ: Case 4 (false=ok) - " + b4);
        }
        if (print) {
            boolean b9 = !b2 && !b3 && !b4;
            System.err.println("LJ: Case !2&!3&!4  (true=ok) - " + b9);
        }
        return !b2 && !b3 && !b4;
    }

    public static Set<Var> nonLinearVars(OpLeftJoin op) {
        Op left = LeftJoinClassifier.effectiveOp(op.getLeft());
        Op right = LeftJoinClassifier.effectiveOp(op.getRight());
        Set<Var> leftVars = OpVars.visibleVars(left);
        Set<Var> optRight = VarFinder.optDefined(right);
        return SetUtils.intersection(leftVars, optRight);
    }

    private static Op effectiveOp(Op op) {
        if (op instanceof OpExt) {
            op = ((OpExt)op).effectiveOp();
        }
        return op;
    }
}

