/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shacl.engine.Targets;
import org.apache.jena.vocabulary.RDF;

public class FocusNodes {
    public static Set<Node> focusNodes(Targets shapes, Graph data) {
        Set<Node> x1 = FocusNodes.focusTargetNode(shapes);
        Set<Node> x2 = FocusNodes.focusTargetClass(shapes, data);
        Set<Node> x3 = FocusNodes.focusTargetObjectsOf(shapes, data);
        Set<Node> x4 = FocusNodes.focusTargetSubjectsOf(shapes, data);
        HashSet<Node> z = new HashSet<Node>();
        z.addAll(x1);
        z.addAll(x2);
        z.addAll(x3);
        z.addAll(x4);
        return z;
    }

    public static Set<Node> focusTargetNode(Targets shapes) {
        return shapes.targetNodes;
    }

    private static void focusTargetNode(Set<Node> acc, Targets shapes) {
        acc.addAll(shapes.targetNodes);
    }

    public static Set<Node> focusTargetClass(Targets shapes, Graph data) {
        Stream<Node> cls = FocusNodes.targetClasses(shapes);
        Set<Node> indiv = cls.flatMap(type -> FocusNodes.stream(data, null, RDF.Nodes.type, type)).map(Triple::getObject).collect(Collectors.toSet());
        return indiv;
    }

    static Stream<Node> targetClasses(Targets shapes) {
        return shapes.targetClasses.stream();
    }

    public static Set<Node> focusTargetObjectsOf(Targets shapes, Graph data) {
        return FocusNodes.focusTargetOf(shapes, shapes.propertyTargetObjectsOf, data, Triple::getObject);
    }

    public static Set<Node> focusTargetSubjectsOf(Targets shapes, Graph data) {
        return FocusNodes.focusTargetOf(shapes, shapes.propertyTargetSubjectsOf, data, Triple::getSubject);
    }

    private static Set<Node> focusTargetOf(Targets shapes, Set<Node> targetOf, Graph data, Function<Triple, Node> projection) {
        Stream<Node> z = targetOf.stream().flatMap(p -> FocusNodes.stream(data, null, p, null)).map(projection);
        return FocusNodes.set(z);
    }

    private static Stream<Triple> stream(Graph g, Node s, Node p, Node o) {
        return Iter.asStream((Iterator)g.find(s, p, o));
    }

    private static Set<Node> set(Stream<Node> z) {
        return z.collect(Collectors.toSet());
    }
}

