/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.sys;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.impl.TransactionHandlerBase;
import org.apache.jena.shacl.GraphValidation;
import org.apache.jena.shacl.ShaclValidationException;
import org.apache.jena.shacl.ShaclValidator;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.system.G;

public class ValidationGraph
extends GraphWrapper {
    private final Shapes shapes;
    private final TransactionHandlerValidate transactionHandler;

    public ValidationGraph(Graph graph, Shapes shapes) {
        super(graph);
        this.shapes = shapes;
        this.transactionHandler = new TransactionHandlerValidate(this, this.get().getTransactionHandler());
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    public ValidationReport updateValidateReport(Runnable action) {
        return GraphValidation.updateAndReport(this.shapes, this.get(), action);
    }

    public ValidationReport updateValidate(Runnable action) throws ShaclValidationException {
        return GraphValidation.update(this.shapes, this.get(), action);
    }

    public ValidationReport updateAndReport(Runnable action) {
        return (ValidationReport)G.calcTxn((Graph)this.get(), () -> {
            action.run();
            return ShaclValidator.get().validate(this.shapes, this.get());
        });
    }

    private static class TransactionHandlerValidate
    extends TransactionHandlerBase {
        private final TransactionHandler other;
        private ValidationGraph graphValidate;

        TransactionHandlerValidate(ValidationGraph graphValidate, TransactionHandler other) {
            this.graphValidate = graphValidate;
            this.other = other;
        }

        public boolean transactionsSupported() {
            return this.other.transactionsSupported();
        }

        public void begin() {
            this.other.begin();
        }

        public void abort() {
            this.other.abort();
        }

        public void commit() {
            ValidationReport report = this.validateCommit();
            throw new ShaclValidationException(report){

                public Throwable fillInStackTrace() {
                    return this;
                }
            };
        }

        private ValidationReport validateCommit() {
            ValidationReport report = ShaclValidator.get().validate(this.graphValidate.shapes, this.graphValidate.get());
            if (report.conforms()) {
                this.other.commit();
                return null;
            }
            this.abort();
            return report;
        }
    }
}

