/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.Responses;
import org.apache.jena.fuseki.servlets.SPARQLProtocol;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.WebContent;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.engine.Timeouts;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.exec.QueryExecResult;
import org.apache.jena.sparql.exec.RowSet;

public abstract class SPARQLQueryProcessor
extends ActionService {
    private static final String QueryParseBase = "http://server/unset-base/";
    private volatile Set<String> acceptedParams_ = null;
    private static Collection<String> customParams_ = Collections.emptyList();
    private static Collection<String> stdParams_ = Arrays.asList("query", "default-graph-uri", "named-graph-uri");
    private static Collection<String> fusekiParams_ = Arrays.asList("query-ref", "stylesheet", "accept", "output", "format", "results", "callback", "force-accept", "timeout");

    @Override
    public void execOptions(HttpAction action) {
        ActionLib.doOptionsGetPost(action);
        ServletOps.success(action);
    }

    @Override
    public void execHead(HttpAction action) {
        super.execHead(action);
    }

    @Override
    public void execGet(HttpAction action) {
        this.executeLifecycle(action);
    }

    @Override
    public void execPost(HttpAction action) {
        this.executeLifecycle(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> acceptedParams(HttpAction action) {
        if (this.acceptedParams_ == null) {
            SPARQLQueryProcessor sPARQLQueryProcessor = this;
            synchronized (sPARQLQueryProcessor) {
                if (this.acceptedParams_ == null) {
                    this.acceptedParams_ = this.generateAcceptedParams();
                }
            }
        }
        return this.acceptedParams_;
    }

    @Override
    public void validate(HttpAction action) {
        String method = Lib.uppercase(action.getRequestMethod());
        if ("OPTIONS".equals(method)) {
            return;
        }
        if (!"POST".equals(method) && !"GET".equals(method)) {
            ServletOps.errorMethodNotAllowed("Not a GET or POST request");
        }
        if ("GET".equals(method) && action.getRequestQueryString() == null) {
            ServletOps.warning(action, "Service Description / SPARQL Query / " + action.getRequestRequestURI());
            ServletOps.errorNotFound("Service Description: " + action.getRequestRequestURI());
        }
        Collection<String> x = this.acceptedParams(action);
        this.validateParams(action, x);
        this.validateRequest(action);
    }

    protected abstract void validateRequest(HttpAction var1);

    protected void validateParams(HttpAction action, Collection<String> params) {
        HttpServletRequest request = action.getRequest();
        ContentType ct = FusekiNetLib.getContentType(request);
        boolean mustHaveQueryParam = true;
        if (ct != null) {
            String incoming = ct.getContentTypeStr();
            if (WebContent.matchContentType(WebContent.ctSPARQLQuery, ct)) {
                mustHaveQueryParam = false;
            } else if (!WebContent.matchContentType(WebContent.ctHTMLForm, ct)) {
                ServletOps.error(415, "Unsupported: " + incoming);
            }
        }
        if (mustHaveQueryParam) {
            String queryStr;
            int N = SPARQLProtocol.countParamOccurences(request, "query");
            if (N == 0) {
                ServletOps.errorBadRequest("SPARQL Query: No 'query=' parameter");
            }
            if (N > 1) {
                ServletOps.errorBadRequest("SPARQL Query: Multiple 'query=' parameters");
            }
            if ((queryStr = request.getParameter("query")) == null) {
                ServletOps.errorBadRequest("SPARQL Query: No query specified (no 'query=' found)");
            }
            if (queryStr.isEmpty()) {
                ServletOps.errorBadRequest("SPARQL Query: Empty query string");
            }
        }
        if (params != null) {
            Enumeration<String> en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                if (params.contains(name)) continue;
                ServletOps.warning(action, "SPARQL Query: Unrecognized request parameter (ignored): " + name);
            }
        }
    }

    @Override
    public final void execute(HttpAction action) {
        if (action.getRequestMethod().equals("GET")) {
            this.executeWithParameter(action);
            return;
        }
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null || WebContent.isHtmlForm(ct)) {
            this.executeWithParameter(action);
            return;
        }
        if (WebContent.matchContentType(ct, WebContent.ctSPARQLQuery)) {
            this.executeBody(action);
            return;
        }
        ServletOps.error(415, "Bad content type: " + ct.getContentTypeStr());
    }

    protected void executeWithParameter(HttpAction action) {
        String queryString = action.getRequestParameter("query");
        this.execute(queryString, action);
    }

    protected void executeBody(HttpAction action) {
        String queryString = null;
        try {
            InputStream input = action.getRequestInputStream();
            queryString = IO.readWholeFileAsUTF8(input);
        }
        catch (Throwable ex) {
            ActionLib.consumeBody(action);
            ServletOps.errorOccurred(ex);
        }
        this.execute(queryString, action);
    }

    protected void execute(String queryString, HttpAction action) {
        String msg;
        if (queryString.isEmpty()) {
            ServletOps.errorBadRequest("Error: Empty query string");
        }
        if (queryString.isBlank()) {
            ServletOps.errorBadRequest("Error: Blank query string");
        }
        String queryStringLog = ServletOps.formatForLog(queryString);
        if (action.verbose) {
            String str2 = queryString;
            if (str2.endsWith("\n")) {
                str2 = str2.substring(0, str2.length() - 1);
            }
            action.log.info(String.format("[%d] Query = \n%s", action.id, str2));
        } else {
            action.log.info(String.format("[%d] Query = %s", action.id, queryStringLog));
        }
        Query query2 = null;
        try {
            query2 = QueryFactory.create(queryString, QueryParseBase, Syntax.syntaxARQ);
            queryStringLog = this.formatForLog(query2);
            this.validateQuery(action, query2);
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (QueryParseException ex) {
            msg = SPARQLProtocol.messageForParseException(ex);
            action.log.warn(String.format("[%d] %s", action.id, msg));
            ServletOps.errorBadRequest(msg);
        }
        catch (QueryException ex) {
            msg = SPARQLProtocol.messageForException(ex);
            action.log.warn(String.format("[%d] %s", action.id, msg));
            ServletOps.errorBadRequest("Error: \n" + queryString + "\n" + msg);
        }
        try {
            action.beginRead();
            Pair<DatasetGraph, Query> p = this.decideDataset(action, query2, queryStringLog);
            DatasetGraph dataset = p.getLeft();
            Query q = p.getRight();
            if (q == null) {
                q = query2;
            }
            try (QueryExec qExec = this.createQueryExec(action, q, dataset);){
                QueryExecResult result = this.executeQuery(action, qExec, query2, queryStringLog);
                this.sendResults(action, result, query2.getPrologue());
            }
        }
        catch (QueryParseException ex) {
            SPARQLQueryProcessor.abortSilent(action);
            ServletOps.errorBadRequest("Query parse error: \n" + queryString + "\n" + SPARQLProtocol.messageForException(ex));
        }
        catch (QueryCancelledException ex) {
            SPARQLQueryProcessor.abortSilent(action);
            ActionExecLib.incCounter(action.getEndpoint().getCounters(), CounterName.QueryTimeouts);
            throw ex;
        }
        finally {
            action.endRead();
        }
    }

    private static void abortSilent(HttpAction action) {
        action.abortSilent();
    }

    protected abstract void validateQuery(HttpAction var1, Query var2);

    protected QueryExec createQueryExec(HttpAction action, Query query2, DatasetGraph dataset) {
        QueryExecDatasetBuilder builder = QueryExec.newBuilder().dataset(dataset).query(query2).context(action.getContext());
        SPARQLQueryProcessor.setTimeouts(builder, action);
        QueryExec qExec = builder.build();
        return qExec;
    }

    private static void setTimeouts(QueryExecDatasetBuilder builder, HttpAction action) {
        Pair<Long, Long> pair1;
        long protocolInitialTimeout = -1L;
        long protocolOverallTimeout = -1L;
        String timeoutParameter = action.getRequestParameter("timeout");
        if (timeoutParameter != null && (pair1 = Timeouts.parseTimeoutStr(timeoutParameter, TimeUnit.SECONDS)) != null) {
            protocolInitialTimeout = pair1.getLeft();
            protocolOverallTimeout = pair1.getRight();
        }
        long cxtInitialTimeout = -1L;
        long cxtOverallTimeout = -1L;
        String timeoutCxt = action.getContext().getAsString(ARQ.queryTimeout);
        if (timeoutCxt != null) {
            Pair<Long, Long> pair2 = Timeouts.parseTimeoutStr(timeoutCxt, TimeUnit.MILLISECONDS);
            cxtInitialTimeout = pair2.getLeft();
            cxtOverallTimeout = pair2.getRight();
        }
        long initialTimeout = SPARQLQueryProcessor.chooseTimeout(cxtInitialTimeout, protocolInitialTimeout);
        long overallTimeout = SPARQLQueryProcessor.chooseTimeout(cxtOverallTimeout, protocolOverallTimeout);
        if (initialTimeout > 0L) {
            builder.initialTimeout(initialTimeout, TimeUnit.MILLISECONDS);
        }
        if (overallTimeout > 0L) {
            builder.overallTimeout(overallTimeout, TimeUnit.MILLISECONDS);
        }
    }

    private static long chooseTimeout(long setupTimeout, long protocolTimeout) {
        if (setupTimeout < 0L) {
            return protocolTimeout;
        }
        if (protocolTimeout > 0L) {
            return Math.min(setupTimeout, protocolTimeout);
        }
        return setupTimeout;
    }

    protected QueryExecResult executeQuery(HttpAction action, QueryExec queryExec, Query requestQuery, String queryStringLog) {
        if (requestQuery.isSelectType()) {
            RowSet rs = queryExec.select();
            rs.hasNext();
            return new QueryExecResult(rs);
        }
        if (requestQuery.isConstructType()) {
            DatasetGraph dataset = queryExec.constructDataset();
            return new QueryExecResult(dataset);
        }
        if (requestQuery.isDescribeType()) {
            Graph graph = queryExec.describe();
            return new QueryExecResult(graph);
        }
        if (requestQuery.isAskType()) {
            boolean b = queryExec.ask();
            return new QueryExecResult(b);
        }
        if (requestQuery.isJsonType()) {
            Iterator<JsonObject> jsonIterator = queryExec.execJsonItems();
            return new QueryExecResult(jsonIterator);
        }
        ServletOps.errorBadRequest("Unknown query type - " + queryStringLog);
        return null;
    }

    protected abstract Pair<DatasetGraph, Query> decideDataset(HttpAction var1, Query var2, String var3);

    protected void sendResults(HttpAction action, QueryExecResult result, Prologue qPrologue) {
        if (result.isRowSet()) {
            Responses.doResponseResultSet(action, result.rowSet(), qPrologue);
        } else if (result.isDataset()) {
            Responses.doResponseDataset(action, result.dataset());
        } else if (result.isGraph()) {
            Responses.doResponseGraph(action, result.graph());
        } else if (result.isBoolean()) {
            Responses.doResponseBoolean(action, result.booleanResult());
        } else if (result.isJson()) {
            Responses.doResponseJson(action, result.jsonItems());
        } else {
            ServletOps.errorOccurred("Unknown or invalid result type");
        }
    }

    private String formatForLog(Query query2) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        query2.serialize(out);
        return out.asString();
    }

    protected Set<String> generateAcceptedParams() {
        HashSet<String> x = new HashSet<String>();
        x.addAll(this.stdParams());
        x.addAll(this.fusekiParams());
        x.addAll(this.customParams());
        return x;
    }

    protected Collection<String> customParams() {
        return customParams_;
    }

    protected Collection<String> stdParams() {
        return stdParams_;
    }

    protected Collection<String> fusekiParams() {
        return fusekiParams_;
    }
}

