/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v2;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jena.geosparql.kryo.EnvelopeSerializer;
import org.apache.jena.geosparql.kryo.NodeSerializer;
import org.apache.jena.geosparql.kryo.TripleSerializer;
import org.apache.jena.geosparql.spatial.index.v2.STRtreePerGraph;
import org.apache.jena.geosparql.spatial.index.v2.STRtreePerGraphSerializer;
import org.apache.jena.graph.Triple;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.index.strtree.STRtreeSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoRegistratorSpatialIndexV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(KryoRegistratorSpatialIndexV2.class);

    public static void registerClasses(Kryo kryo, Serializer<Geometry> geometrySerializer) {
        LOGGER.debug("Registering kryo serializers for spatial index v2.");
        MapSerializer mapSerializer = new MapSerializer();
        kryo.register(Map.class, mapSerializer);
        kryo.register(HashMap.class, mapSerializer);
        kryo.register(LinkedHashMap.class, mapSerializer);
        NodeSerializer.register(kryo);
        KryoRegistratorSpatialIndexV2.registerTripleSerializer(kryo);
        kryo.register(STRtree.class, new STRtreeSerializer());
        kryo.register(Envelope.class, new EnvelopeSerializer());
        kryo.register(STRtreePerGraph.class, new STRtreePerGraphSerializer());
        if (geometrySerializer != null) {
            KryoRegistratorSpatialIndexV2.registerGeometrySerializers(kryo, geometrySerializer);
        }
    }

    public static void registerTripleSerializer(Kryo kryo) {
        kryo.register(Triple.class, new TripleSerializer());
    }

    public static void registerGeometrySerializers(Kryo kryo, Serializer<Geometry> geometrySerializer) {
        kryo.register(Point.class, geometrySerializer);
        kryo.register(LinearRing.class, geometrySerializer);
        kryo.register(LineString.class, geometrySerializer);
        kryo.register(Polygon.class, geometrySerializer);
        kryo.register(MultiPoint.class, geometrySerializer);
        kryo.register(MultiLineString.class, geometrySerializer);
        kryo.register(MultiPolygon.class, geometrySerializer);
        kryo.register(GeometryCollection.class, geometrySerializer);
    }
}

