/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter2LoopOnLeft;

public class QueryIterHalfJoin
extends QueryIter2LoopOnLeft {
    private final HALF_JOIN halfJoin;

    public static QueryIterator semiJoin(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        return new QueryIterHalfJoin(HALF_JOIN.SEMI, left, right, execCxt);
    }

    public static QueryIterator antiJoin(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        return new QueryIterHalfJoin(HALF_JOIN.ANTI, left, right, execCxt);
    }

    private QueryIterHalfJoin(HALF_JOIN halfJoin, QueryIterator left, QueryIterator right, ExecutionContext qCxt) {
        super(left, right, qCxt);
        this.halfJoin = halfJoin;
    }

    @Override
    protected Binding getNextSlot(Binding bindingLeft) {
        boolean accept = true;
        QueryIterator iter = this.tableRight.iterator(null);
        while (iter.hasNext()) {
            Binding bindingRight = (Binding)iter.next();
            boolean matches = Algebra.compatible(bindingLeft, bindingRight);
            if (!matches) continue;
            return this.halfJoin.onOneMatch(bindingLeft);
        }
        return this.halfJoin.onNoMatches(bindingLeft);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum HALF_JOIN {
        SEMI{

            @Override
            public Binding onOneMatch(Binding bindingLeft) {
                return bindingLeft;
            }

            @Override
            public Binding onNoMatches(Binding bindingLeft) {
                return null;
            }
        }
        ,
        ANTI{

            @Override
            public Binding onOneMatch(Binding bindingLeft) {
                return null;
            }

            @Override
            public Binding onNoMatches(Binding bindingLeft) {
                return bindingLeft;
            }
        };


        public abstract Binding onOneMatch(Binding var1);

        public abstract Binding onNoMatches(Binding var1);
    }
}

