/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.html;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.jena.fuseki.validation.html.ValidatorHtmlLib;
import org.apache.jena.langtag.LangTag;
import org.apache.jena.langtag.LangTagException;
import org.apache.jena.langtag.SysLangTag;
import org.apache.jena.shared.JenaException;

public class LangTagValidatorHTML {
    static final String paramLang = "lang";
    static final String paramLangTag = "langtag";

    private LangTagValidatorHTML() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeHTML(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String[] args1 = httpRequest.getParameterValues(paramLang);
            String[] args2 = httpRequest.getParameterValues(paramLangTag);
            if (args1 == null && args2 == null) {
                httpResponse.sendError(400, "No ?lang= parameter");
            }
            ArrayList<String> args = new ArrayList<String>();
            if (args1 != null) {
                for (String a : args1) {
                    args.add(a);
                }
            }
            if (args2 != null) {
                for (String a : args2) {
                    args.add(a);
                }
            }
            if (args.size() == 0) {
                httpResponse.sendError(400, "No language tags");
            }
            ServletOutputStream outStream = httpResponse.getOutputStream();
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            System.setOut(new PrintStream(outStream));
            System.setErr(new PrintStream(outStream));
            ValidatorHtmlLib.setHeaders(httpResponse);
            outStream.println("<html>");
            ValidatorHtmlLib.printHead(outStream, "Apache Jena LangTag");
            outStream.println("<body>");
            outStream.println("<h1>LangTag Report</h1>");
            ValidatorHtmlLib.startFixed(outStream);
            try {
                boolean first = true;
                for (String languageTag : args) {
                    if (!first) {
                        System.out.println();
                    }
                    first = false;
                    outStream.println(String.format("%-16s %s", "Input:    ", languageTag));
                    if (languageTag.isEmpty()) {
                        outStream.println("Empty string for language tag");
                        continue;
                    }
                    if (languageTag.isBlank()) {
                        outStream.println("Blank string for language tag");
                        continue;
                    }
                    if (languageTag.contains(" ") || languageTag.contains("\t") || languageTag.contains("\n") || languageTag.contains("\r")) {
                        outStream.println("Language tag contains white space");
                        continue;
                    }
                    if (languageTag.contains("--")) {
                        outStream.println("Illgeal language tag. String contains '--'");
                        continue;
                    }
                    try {
                        LangTag langTag = SysLangTag.create(languageTag);
                        outStream.println(String.format("%-16s %s", "Formatted:", langTag.str()));
                        LangTagValidatorHTML.print(outStream, "Formatted:", langTag.str(), true);
                        LangTagValidatorHTML.print(outStream, "Language:", langTag.getLanguage(), true);
                        LangTagValidatorHTML.print(outStream, "Script:", langTag.getScript(), true);
                        LangTagValidatorHTML.print(outStream, "Region:", langTag.getRegion(), true);
                        LangTagValidatorHTML.print(outStream, "Variant:", langTag.getVariant(), false);
                        LangTagValidatorHTML.print(outStream, "Extension:", langTag.getExtension(), false);
                        LangTagValidatorHTML.print(outStream, "Private Use:", langTag.getPrivateUse(), false);
                    }
                    catch (LangTagException | JenaException ex) {
                        outStream.println("Bad language tag: " + ex.getMessage());
                    }
                }
            }
            finally {
                ValidatorHtmlLib.finishFixed(outStream);
                System.out.flush();
                System.err.flush();
                System.setOut(stdout);
                System.setErr(stdout);
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void print(ServletOutputStream outStream, String label, String value, boolean always) throws IOException {
        if (value == null) {
            if (!always) {
                return;
            }
            value = "-";
        }
        outStream.print(String.format("  %-14s %s\n", label, value));
    }
}

