/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.util.ThreadInterruptedException;

public class TotalHitCountCollectorManager
implements CollectorManager<TotalHitCountCollector, Integer> {
    private final boolean hasSegmentPartitions;
    private final Map<Object, Future<Boolean>> earlyTerminatedMap = new ConcurrentHashMap<Object, Future<Boolean>>();

    public TotalHitCountCollectorManager(IndexSearcher.LeafSlice[] leafSlices) {
        this.hasSegmentPartitions = TotalHitCountCollectorManager.hasSegmentPartitions(leafSlices);
    }

    private static boolean hasSegmentPartitions(IndexSearcher.LeafSlice[] leafSlices) {
        for (IndexSearcher.LeafSlice leafSlice : leafSlices) {
            for (IndexSearcher.LeafReaderContextPartition leafPartition : leafSlice.partitions) {
                if (leafPartition.minDocId <= 0 && leafPartition.maxDocId >= leafPartition.ctx.reader().maxDoc()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public TotalHitCountCollector newCollector() throws IOException {
        if (this.hasSegmentPartitions) {
            return new LeafPartitionAwareTotalHitCountCollector(this.earlyTerminatedMap);
        }
        return new TotalHitCountCollector();
    }

    @Override
    public Integer reduce(Collection<TotalHitCountCollector> collectors) throws IOException {
        assert (this.hasSegmentPartitions || this.earlyTerminatedMap.isEmpty());
        if (this.hasSegmentPartitions) {
            this.earlyTerminatedMap.clear();
        }
        int totalHits = 0;
        for (TotalHitCountCollector collector : collectors) {
            totalHits += collector.getTotalHits();
        }
        return totalHits;
    }

    private static class LeafPartitionAwareTotalHitCountCollector
    extends TotalHitCountCollector {
        private final Map<Object, Future<Boolean>> earlyTerminatedMap;

        LeafPartitionAwareTotalHitCountCollector(Map<Object, Future<Boolean>> earlyTerminatedMap) {
            this.earlyTerminatedMap = earlyTerminatedMap;
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context2) throws IOException {
            Future earlyTerminated = this.earlyTerminatedMap.get(context2.id());
            if (earlyTerminated == null) {
                CompletableFuture<Boolean> firstEarlyTerminated = new CompletableFuture<Boolean>();
                Future previousEarlyTerminated = this.earlyTerminatedMap.putIfAbsent(context2.id(), firstEarlyTerminated);
                if (previousEarlyTerminated == null) {
                    try {
                        LeafCollector leafCollector = super.getLeafCollector(context2);
                        firstEarlyTerminated.complete(false);
                        return leafCollector;
                    }
                    catch (CollectionTerminatedException e2) {
                        firstEarlyTerminated.complete(true);
                        throw e2;
                    }
                }
                earlyTerminated = previousEarlyTerminated;
            }
            try {
                if (earlyTerminated.get().booleanValue()) {
                    throw new CollectionTerminatedException();
                }
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new ThreadInterruptedException(e3);
            }
            catch (ExecutionException e4) {
                throw new RuntimeException(e4);
            }
            return this.createLeafCollector();
        }
    }
}

