/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.NegotiatingClientConnectionFactory;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ALPNClientConnectionFactory
extends NegotiatingClientConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ALPNClientConnectionFactory.class);
    private final List<ALPNProcessor.Client> processors = new ArrayList<ALPNProcessor.Client>();
    private final Executor executor;
    private final List<String> protocols;

    public ALPNClientConnectionFactory(Executor executor, ClientConnectionFactory connectionFactory, List<String> protocols) {
        super(connectionFactory);
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("ALPN protocol list cannot be empty");
        }
        this.executor = executor;
        this.protocols = protocols;
        IllegalStateException failure = new IllegalStateException("No Client ALPNProcessors!");
        TypeUtil.serviceProviderStream(ServiceLoader.load(ALPNProcessor.Client.class)).forEach(provider -> {
            ALPNProcessor.Client processor;
            try {
                processor = (ALPNProcessor.Client)provider.get();
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("Unable to load client processor");
                }
                failure.addSuppressed(x);
                return;
            }
            try {
                processor.init();
                this.processors.add(processor);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("Could not initialize {}", (Object)processor);
                }
                failure.addSuppressed(x);
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("protocols: {}", (Object)protocols);
            LOG.debug("processors: {}", (Object)this.processors);
        }
        if (this.processors.isEmpty()) {
            throw failure;
        }
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context2) {
        SSLEngine engine = (SSLEngine)context2.get(SSLEngine.class.getName());
        for (ALPNProcessor.Client processor : this.processors) {
            if (!processor.appliesTo(engine)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} for {} on {}", processor, engine, endPoint);
            }
            ALPNClientConnection connection = new ALPNClientConnection(endPoint, this.executor, this.getWrapped(), engine, context2, this.protocols);
            processor.configure(engine, connection);
            return this.customize(connection, context2);
        }
        throw new IllegalStateException("No ALPNProcessor for " + String.valueOf(engine));
    }
}

