/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriResolver;
import org.apache.juneau.Value;
import org.apache.juneau.ValueListener;
import org.apache.juneau.config.Config;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.HasFormData;
import org.apache.juneau.http.annotation.HasQuery;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.httppart.HttpPart;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RequestAttributes;
import org.apache.juneau.rest.RequestBody;
import org.apache.juneau.rest.RequestFormData;
import org.apache.juneau.rest.RequestHeaders;
import org.apache.juneau.rest.RequestPath;
import org.apache.juneau.rest.RequestProperties;
import org.apache.juneau.rest.RequestQuery;
import org.apache.juneau.rest.ResponsePartMeta;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestParamType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.annotation.Attr;
import org.apache.juneau.rest.util.UrlPathPattern;
import org.apache.juneau.serializer.SerializeException;

class RestParamDefaults {
    static final Map<Class<?>, RestMethodParam> STANDARD_RESOLVERS;

    RestParamDefaults() {
    }

    static final boolean isCollection(Type t) {
        return BeanContext.DEFAULT.getClassMeta(t, new Type[0]).isCollectionOrArray();
    }

    static final HttpPartParser createPartParser(Class<? extends HttpPartParser> p, PropertyStore ps) {
        return (HttpPartParser)ClassUtils.castOrCreate(HttpPartParser.class, p, (boolean)true, (Object[])new Object[]{ps});
    }

    static final HttpPartSerializer createPartSerializer(Class<? extends HttpPartSerializer> s, PropertyStore ps) {
        return (HttpPartSerializer)ClassUtils.castOrCreate(HttpPartSerializer.class, s, (boolean)true, (Object[])new Object[]{ps});
    }

    static {
        Class[] r;
        HashMap m = new HashMap();
        for (Class c : r = new Class[]{HttpServletRequestObject.class, RestRequestObject.class, HttpServletResponseObject.class, RestResponseObject.class, TimeZoneHeader.class, ResourceBundleObject.class, MessageBundleObject.class, InputStreamObject.class, ServletInputStreamObject.class, ReaderObject.class, OutputStreamObject.class, ServletOutputStreamObject.class, WriterObject.class, RequestHeadersObject.class, RequestAttributesObject.class, RequestQueryObject.class, RequestFormDataObject.class, RestLoggerObject.class, RestContextObject.class, ParserObject.class, ReaderParserObject.class, InputStreamParserObject.class, LocaleObject.class, SwaggerObject.class, RequestPathMatchObject.class, RequestBodyObject.class, ConfigObject.class, UriContextObject.class, UriResolverObject.class, RestRequestPropertiesObject.class}) {
            try {
                RestMethodParam mpr = (RestMethodParam)c.newInstance();
                m.put(mpr.forClass(), mpr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        STANDARD_RESOLVERS = Collections.unmodifiableMap(m);
    }

    static final class UriResolverObject
    extends RestMethodParam {
        protected UriResolverObject() {
            super(RestParamType.OTHER, (Type)((Object)UriResolver.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getUriResolver();
        }
    }

    static final class UriContextObject
    extends RestMethodParam {
        protected UriContextObject() {
            super(RestParamType.OTHER, (Type)((Object)UriContext.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getUriContext();
        }
    }

    static final class ConfigObject
    extends RestMethodParam {
        protected ConfigObject() {
            super(RestParamType.OTHER, (Type)((Object)Config.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getConfig();
        }
    }

    static final class RequestBodyObject
    extends RestMethodParam {
        protected RequestBodyObject() {
            super(RestParamType.OTHER, (Type)((Object)RequestBody.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getBody();
        }
    }

    static final class RequestPathMatchObject
    extends RestMethodParam {
        protected RequestPathMatchObject() {
            super(RestParamType.OTHER, (Type)((Object)RequestPath.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getPathMatch();
        }
    }

    static final class SwaggerObject
    extends RestMethodParam {
        protected SwaggerObject() {
            super(RestParamType.OTHER, (Type)((Object)Swagger.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getSwagger();
        }
    }

    static final class LocaleObject
    extends RestMethodParam {
        protected LocaleObject() {
            super(RestParamType.OTHER, (Type)((Object)Locale.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getLocale();
        }
    }

    static final class InputStreamParserObject
    extends RestMethodParam {
        protected InputStreamParserObject() {
            super(RestParamType.OTHER, (Type)((Object)InputStreamParser.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getBody().getInputStreamParser();
        }
    }

    static final class ReaderParserObject
    extends RestMethodParam {
        protected ReaderParserObject() {
            super(RestParamType.OTHER, (Type)((Object)ReaderParser.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getBody().getReaderParser();
        }
    }

    static final class ParserObject
    extends RestMethodParam {
        protected ParserObject() {
            super(RestParamType.OTHER, (Type)((Object)Parser.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getBody().getParser();
        }
    }

    static final class RestContextObject
    extends RestMethodParam {
        protected RestContextObject() {
            super(RestParamType.OTHER, (Type)((Object)RestContext.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getContext();
        }
    }

    static final class RestLoggerObject
    extends RestMethodParam {
        protected RestLoggerObject() {
            super(RestParamType.OTHER, (Type)((Object)RestLogger.class));
        }

        @Override
        public RestLogger resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getContext().getLogger();
        }
    }

    static final class RequestFormDataObject
    extends RestMethodParam {
        protected RequestFormDataObject() {
            super(RestParamType.OTHER, (Type)((Object)RequestFormData.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getFormData();
        }
    }

    static final class RequestQueryObject
    extends RestMethodParam {
        protected RequestQueryObject() {
            super(RestParamType.OTHER, (Type)((Object)RequestQuery.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getQuery();
        }
    }

    static final class RequestAttributesObject
    extends RestMethodParam {
        protected RequestAttributesObject() {
            super(RestParamType.OTHER, (Type)((Object)RequestAttributes.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getAttributes();
        }
    }

    static final class RequestHeadersObject
    extends RestMethodParam {
        protected RequestHeadersObject() {
            super(RestParamType.OTHER, (Type)((Object)RequestHeaders.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getHeaders();
        }
    }

    static final class WriterObject
    extends RestMethodParam {
        protected WriterObject() {
            super(RestParamType.OTHER, (Type)((Object)Writer.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return res.getWriter();
        }
    }

    static final class ServletOutputStreamObject
    extends RestMethodParam {
        protected ServletOutputStreamObject() {
            super(RestParamType.OTHER, (Type)((Object)ServletOutputStream.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return res.getOutputStream();
        }
    }

    static final class OutputStreamObject
    extends RestMethodParam {
        protected OutputStreamObject() {
            super(RestParamType.OTHER, (Type)((Object)OutputStream.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return res.getOutputStream();
        }
    }

    static final class ReaderObject
    extends RestMethodParam {
        protected ReaderObject() {
            super(RestParamType.OTHER, (Type)((Object)Reader.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getReader();
        }
    }

    static final class ServletInputStreamObject
    extends RestMethodParam {
        protected ServletInputStreamObject() {
            super(RestParamType.OTHER, (Type)((Object)ServletInputStream.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getInputStream();
        }
    }

    static final class InputStreamObject
    extends RestMethodParam {
        protected InputStreamObject() {
            super(RestParamType.OTHER, (Type)((Object)InputStream.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getInputStream();
        }
    }

    static final class MessageBundleObject
    extends RestMethodParam {
        protected MessageBundleObject() {
            super(RestParamType.OTHER, (Type)((Object)Messages.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getMessages();
        }
    }

    static final class ResourceBundleObject
    extends RestMethodParam {
        protected ResourceBundleObject() {
            super(RestParamType.OTHER, (Type)((Object)ResourceBundle.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getMessages();
        }
    }

    @Deprecated
    static final class RestRequestPropertiesObject
    extends RestMethodParam {
        protected RestRequestPropertiesObject() {
            super(RestParamType.OTHER, (Type)((Object)RequestProperties.class));
        }

        public RequestProperties resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getProperties();
        }
    }

    static final class HasQueryObject
    extends RestMethodParam {
        protected HasQueryObject(ParamInfo mpi) throws ServletException {
            super(RestParamType.QUERY, mpi, HasQueryObject.getName(mpi));
            if (this.getType() != Boolean.class && this.getType() != Boolean.TYPE) {
                throw new RestServletException("Use of @HasQuery annotation on parameter that is not a boolean on method ''{0}''", mpi.getMethod());
            }
        }

        private static String getName(ParamInfo mpi) {
            String n = null;
            for (HasQuery h : mpi.getAnnotations(HasQuery.class)) {
                n = StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.n(), h.value(), n});
            }
            if (n == null) {
                throw new InternalServerError("@HasQuery used without name or value on method parameter ''{0}''.", new Object[]{mpi});
            }
            return n;
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            BeanSession bs = req.getBeanSession();
            return bs.convertToType((Object)req.getQuery().containsKey(this.name), bs.getClassMeta(this.type, new Type[0]));
        }
    }

    static final class HasFormDataObject
    extends RestMethodParam {
        protected HasFormDataObject(ParamInfo mpi) throws ServletException {
            super(RestParamType.FORM_DATA, mpi, HasFormDataObject.getName(mpi));
            if (this.getType() != Boolean.class && this.getType() != Boolean.TYPE) {
                throw new RestServletException("Use of @HasForm annotation on parameter that is not a boolean on method ''{0}''", mpi.getMethod());
            }
        }

        private static String getName(ParamInfo mpi) {
            String n = null;
            for (HasFormData h : mpi.getAnnotations(HasFormData.class)) {
                n = StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.n(), h.value(), n});
            }
            if (n == null) {
                throw new InternalServerError("@HasFormData used without name or value on method parameter ''{o}''.", new Object[]{mpi});
            }
            return n;
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            BeanSession bs = req.getBeanSession();
            return bs.convertToType((Object)req.getFormData().containsKey(this.name), bs.getClassMeta(this.type, new Type[0]));
        }
    }

    static final class QueryObject
    extends RestMethodParam {
        private final boolean multi;
        private final HttpPartParser partParser;
        private final HttpPartSchema schema;

        protected QueryObject(ParamInfo mpi, PropertyStore ps) {
            super(RestParamType.QUERY, mpi, QueryObject.getName(mpi));
            this.schema = HttpPartSchema.create(Query.class, (ParamInfo)mpi);
            this.partParser = RestParamDefaults.createPartParser(this.schema.getParser(), ps);
            boolean bl = this.multi = QueryObject.getMulti(mpi) || this.schema.getCollectionFormat() == HttpPartCollectionFormat.MULTI;
            if (this.multi && !RestParamDefaults.isCollection(this.type)) {
                throw new InternalServerError("Use of multipart flag on @Query parameter that's not an array or Collection on method ''{0}''", new Object[]{mpi.getMethod()});
            }
        }

        private static String getName(ParamInfo mpi) {
            String n = null;
            for (Query h : mpi.getAnnotations(Query.class)) {
                n = StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.n(), h.value(), n});
            }
            if (n == null) {
                throw new InternalServerError("@Query used without name or value on method param ''{0}''.", new Object[]{mpi});
            }
            return n;
        }

        private static boolean getMulti(ParamInfo mpi) {
            for (Query q : mpi.getAnnotations(Query.class)) {
                if (!q.multi()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            HttpPartParserSession ps = this.partParser == null ? req.getPartParser() : this.partParser.createPartSession(req.getParserSessionArgs());
            RequestQuery rq = req.getQuery();
            return this.multi ? rq.getAll(ps, this.schema, this.name, this.type, new Type[0]) : rq.get(ps, this.schema, this.name, this.type, new Type[0]);
        }
    }

    static final class FormDataObject
    extends RestMethodParam {
        private final boolean multi;
        private final HttpPartParser partParser;
        private final HttpPartSchema schema;

        protected FormDataObject(ParamInfo mpi, PropertyStore ps) {
            super(RestParamType.FORM_DATA, mpi, FormDataObject.getName(mpi));
            this.schema = HttpPartSchema.create(FormData.class, (ParamInfo)mpi);
            this.partParser = RestParamDefaults.createPartParser(this.schema.getParser(), ps);
            boolean bl = this.multi = FormDataObject.getMulti(mpi) || this.schema.getCollectionFormat() == HttpPartCollectionFormat.MULTI;
            if (this.multi && !RestParamDefaults.isCollection(this.type)) {
                throw new InternalServerError("Use of multipart flag on @FormData parameter that's not an array or Collection on method ''{0}''", new Object[]{mpi.getMethod()});
            }
        }

        private static String getName(ParamInfo mpi) {
            String n = null;
            for (FormData h : mpi.getAnnotations(FormData.class)) {
                n = StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.n(), h.value(), n});
            }
            if (n == null) {
                throw new InternalServerError("@FormData used without name or value on method parameter ''{0}''.", new Object[]{mpi});
            }
            return n;
        }

        private static boolean getMulti(ParamInfo mpi) {
            for (FormData f : mpi.getAnnotations(FormData.class)) {
                if (!f.multi()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            HttpPartParserSession ps = this.partParser == null ? req.getPartParser() : this.partParser.createPartSession(req.getParserSessionArgs());
            RequestFormData fd = req.getFormData();
            return this.multi ? fd.getAll(ps, this.schema, this.name, this.type, new Type[0]) : fd.get(ps, this.schema, this.name, this.type, new Type[0]);
        }
    }

    static final class MethodObject
    extends RestMethodParam {
        protected MethodObject(MethodInfo m, ClassInfo t, ParamInfo mpi) throws ServletException {
            super(RestParamType.OTHER, mpi);
            if (!t.is(String.class)) {
                throw new RestServletException("Use of @Method annotation on parameter that is not a String on method ''{0}''", m.inner());
            }
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getMethod();
        }
    }

    static class ResponseStatusObject
    extends RestMethodParam {
        protected ResponseStatusObject(ClassInfo t) {
            super(RestParamType.RESPONSE_STATUS, t);
            if (this.getTypeClass() != Value.class || Value.getParameterType((Type)t.innerType()) != Integer.class) {
                throw new InternalServerError("Invalid type {0} specified with @ResponseStatus annotation.  It must Value<Integer>.", new Object[]{this.type});
            }
        }

        @Override
        public Object resolve(RestRequest req, final RestResponse res) throws Exception {
            Value v = (Value)this.c.newInstance();
            v.listener(new ValueListener(){

                public void onSet(Object o) {
                    res.setStatus(Integer.parseInt(o.toString()));
                }
            });
            return v;
        }
    }

    static final class ResponseObject
    extends RestMethodParam {
        final ResponseBeanMeta meta;

        protected ResponseObject(ParamInfo mpi, PropertyStore ps) {
            super(RestParamType.RESPONSE, mpi);
            this.meta = ResponseBeanMeta.create((ParamInfo)mpi, (PropertyStore)ps);
            if (this.getTypeClass() != Value.class) {
                throw new InternalServerError("Invalid type {0} specified with @Response annotation.  It must be Value.", new Object[]{this.type});
            }
        }

        @Override
        public Object resolve(final RestRequest req, final RestResponse res) throws Exception {
            Value v = (Value)this.c.newInstance();
            v.listener(new ValueListener(){

                public void onSet(Object o) {
                    ResponseBeanMeta meta = req.getResponseBeanMeta(o);
                    if (meta == null) {
                        meta = meta;
                    }
                    res.setResponseMeta(meta);
                    res.setOutput(o);
                }
            });
            return v;
        }
    }

    static final class ResponseHeaderObject
    extends RestMethodParam {
        final ResponsePartMeta meta;

        protected ResponseHeaderObject(ParamInfo mpi, PropertyStore ps) {
            super(RestParamType.RESPONSE_HEADER, mpi, ResponseHeaderObject.getName(mpi));
            HttpPartSchema schema = HttpPartSchema.create(ResponseHeader.class, (ParamInfo)mpi);
            this.meta = new ResponsePartMeta(HttpPartType.HEADER, schema, RestParamDefaults.createPartSerializer(schema.getSerializer(), ps));
            if (this.getTypeClass() != Value.class) {
                throw new InternalServerError("Invalid type {0} specified with @ResponseHeader annotation.  It must be Value.", new Object[]{this.type});
            }
        }

        private static String getName(ParamInfo mpi) {
            String n = null;
            for (ResponseHeader h : mpi.getAnnotations(ResponseHeader.class)) {
                n = StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.n(), h.value(), n});
            }
            if (n == null) {
                throw new InternalServerError("@ResponseHeader used without name or value on method parameter ''{0}''.", new Object[]{mpi});
            }
            return n;
        }

        @Override
        public Object resolve(final RestRequest req, final RestResponse res) throws Exception {
            Value v = (Value)this.getTypeClass().newInstance();
            v.listener(new ValueListener(){

                public void onSet(Object o) {
                    try {
                        ResponsePartMeta rpm = req.getResponseHeaderMeta(o);
                        if (rpm == null) {
                            rpm = meta;
                        }
                        HttpPartSerializerSession pss = rpm.getSerializer() == null ? req.getPartSerializer() : rpm.getSerializer().createPartSession(req.getSerializerSessionArgs());
                        res.setHeader(new HttpPart(name, HttpPartType.HEADER, rpm.getSchema(), pss, o));
                    }
                    catch (SchemaValidationException | SerializeException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return v;
        }
    }

    static final class RequestObject
    extends RestMethodParam {
        private final RequestBeanMeta meta;

        protected RequestObject(ParamInfo mpi, PropertyStore ps) {
            super(RestParamType.RESPONSE_BODY, mpi);
            this.meta = RequestBeanMeta.create((ParamInfo)mpi, (PropertyStore)ps);
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getRequest(this.meta);
        }
    }

    static final class AttributeObject
    extends RestMethodParam {
        protected AttributeObject(ParamInfo mpi, PropertyStore ps) {
            super(RestParamType.OTHER, mpi, AttributeObject.getName(mpi));
        }

        private static String getName(ParamInfo mpi) {
            String n = null;
            for (Attr h : mpi.getAnnotations(Attr.class)) {
                n = StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.value(), n});
            }
            if (n == null) {
                throw new InternalServerError("@Attr used without name or value on method parameter ''{0}''.", new Object[]{mpi});
            }
            return n;
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getAttributes().get(this.name, this.type, new Type[0]);
        }
    }

    static final class HeaderObject
    extends RestMethodParam {
        private final HttpPartParser partParser;
        private final HttpPartSchema schema;
        private final boolean multi;

        protected HeaderObject(ParamInfo mpi, PropertyStore ps) {
            super(RestParamType.HEADER, mpi, HeaderObject.getName(mpi));
            this.schema = HttpPartSchema.create(Header.class, (ParamInfo)mpi);
            this.partParser = RestParamDefaults.createPartParser(this.schema.getParser(), ps);
            this.multi = HeaderObject.getMulti(mpi);
            if (this.multi && !RestParamDefaults.isCollection(this.type)) {
                throw new InternalServerError("Use of multipart flag on @Header parameter that's not an array or Collection on method ''{0}''", new Object[]{mpi.getMethod()});
            }
        }

        private static String getName(ParamInfo mpi) {
            String n = null;
            for (Header h : mpi.getAnnotations(Header.class)) {
                n = StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.n(), h.value(), n});
            }
            if (n == null) {
                throw new InternalServerError("@Header used without name or value on method parameter ''{0}''.", new Object[]{mpi});
            }
            return n;
        }

        private static boolean getMulti(ParamInfo mpi) {
            for (Header h : mpi.getAnnotations(Header.class)) {
                if (!h.multi()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            HttpPartParserSession ps = this.partParser == null ? req.getPartParser() : this.partParser.createPartSession(req.getParserSessionArgs());
            RequestHeaders rh = req.getHeaders();
            return this.multi ? rh.getAll(ps, this.schema, this.name, this.type, new Type[0]) : rh.get(ps, this.schema, this.name, this.type, new Type[0]);
        }
    }

    static final class BodyObject
    extends RestMethodParam {
        private final HttpPartSchema schema;

        protected BodyObject(ParamInfo mpi, PropertyStore ps) {
            super(RestParamType.BODY, mpi);
            this.schema = HttpPartSchema.create(Body.class, (ParamInfo)mpi);
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getBody().schema(this.schema).asType(this.type, new Type[0]);
        }
    }

    static final class PathObject
    extends RestMethodParam {
        private final HttpPartParser partParser;
        private final HttpPartSchema schema;

        protected PathObject(ParamInfo mpi, PropertyStore ps, UrlPathPattern pathPattern) {
            super(RestParamType.PATH, mpi, PathObject.getName(mpi, pathPattern));
            this.schema = HttpPartSchema.create(Path.class, (ParamInfo)mpi);
            this.partParser = RestParamDefaults.createPartParser(this.schema.getParser(), ps);
        }

        private static String getName(ParamInfo mpi, UrlPathPattern pathPattern) {
            String p = null;
            for (Path h : mpi.getAnnotations(Path.class)) {
                p = StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.n(), h.value(), p});
            }
            if (p != null) {
                return p;
            }
            if (pathPattern != null) {
                int idx = 0;
                int i = mpi.getIndex();
                MethodInfo mi = mpi.getMethod();
                for (int j = 0; j < i; ++j) {
                    if (mi.getParam(i).getLastAnnotation(Path.class) == null) continue;
                    ++idx;
                }
                String[] vars = pathPattern.getVars();
                if (vars.length <= idx) {
                    throw new InternalServerError("Number of attribute parameters in method ''{0}'' exceeds the number of URL pattern variables.", new Object[]{mi.getShortName()});
                }
                String idxs = String.valueOf(idx);
                for (int j = 0; j < vars.length; ++j) {
                    if (!StringUtils.isNumeric((String)vars[j]) || !vars[j].equals(idxs)) continue;
                    return vars[j];
                }
                return pathPattern.getVars()[idx];
            }
            throw new InternalServerError("@Path used without name or value on method parameter ''{0}''.", new Object[]{mpi});
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            HttpPartParserSession ps = this.partParser == null ? req.getPartParser() : this.partParser.createPartSession(req.getParserSessionArgs());
            return req.getPathMatch().get(ps, this.schema, this.name, this.type, new Type[0]);
        }
    }

    static final class TimeZoneHeader
    extends RestMethodParam {
        protected TimeZoneHeader() {
            super(RestParamType.HEADER, "Time-Zone", (Type)((Object)TimeZone.class));
        }

        @Override
        public TimeZone resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getTimeZone();
        }
    }

    static final class RestResponseObject
    extends RestMethodParam {
        protected RestResponseObject() {
            super(RestParamType.OTHER, (Type)((Object)RestResponse.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) {
            return res;
        }
    }

    static final class RestRequestObject
    extends RestMethodParam {
        protected RestRequestObject() {
            super(RestParamType.OTHER, (Type)((Object)RestRequest.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) {
            return req;
        }
    }

    static final class HttpServletResponseObject
    extends RestMethodParam {
        protected HttpServletResponseObject() {
            super(RestParamType.OTHER, (Type)((Object)HttpServletResponse.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) {
            return res;
        }
    }

    static final class HttpServletRequestObject
    extends RestMethodParam {
        protected HttpServletRequestObject() {
            super(RestParamType.OTHER, (Type)((Object)HttpServletRequest.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) {
            return req;
        }
    }
}

