/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.rest.util.BoundedServletInputStream;

public class CachingHttpServletRequest
extends HttpServletRequestWrapper {
    private final byte[] body;

    public static CachingHttpServletRequest wrap(HttpServletRequest req) throws IOException {
        if (req instanceof CachingHttpServletRequest) {
            return (CachingHttpServletRequest)req;
        }
        return new CachingHttpServletRequest(req);
    }

    protected CachingHttpServletRequest(HttpServletRequest req) throws IOException {
        super(req);
        this.body = IOUtils.readBytes((InputStream)req.getInputStream());
    }

    public ServletInputStream getInputStream() {
        return new BoundedServletInputStream(this.body);
    }

    public byte[] getBody() {
        return this.body;
    }
}

