/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.time.ZoneId;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.SessionArgs;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.reflect.ClassInfo;

public abstract class Session {
    private final OMap properties;
    private Map<String, Object> cache;
    private List<String> warnings;
    private final boolean debug;
    private final Locale locale;
    private final TimeZone timeZone;
    private final MediaType mediaType;

    protected Session(Context ctx, SessionArgs args) {
        this.properties = args.properties == null ? OMap.EMPTY_MAP : args.properties;
        this.debug = this.getProperty("Context.debug.b", (Class<T>)Boolean.class, (T)ctx.isDebug());
        this.locale = this.getProperty("Context.locale.s", (Class<T>)Locale.class, (T)ctx.getDefaultLocale());
        this.timeZone = this.getProperty("Context.timeZone.s", (Class<T>)TimeZone.class, (T)ctx.getDefaultTimeZone());
        this.mediaType = this.getProperty("Context.mediaType.s", (Class<T>)MediaType.class, (T)ctx.getDefaultMediaType());
    }

    public final boolean hasProperty(String key) {
        return this.properties != null && this.properties.containsKey(key);
    }

    public final Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public final <T> T getProperty(String key, Class<T> type, T def) {
        if (this.properties == null) {
            return def;
        }
        Object o = this.properties.get(key);
        if (o == null) {
            return def;
        }
        T t = this.properties.get(key, type = ClassInfo.of(type).getWrapperIfPrimitive());
        return t == null ? def : t;
    }

    @SafeVarargs
    public final <T> T getProperty(String key, Class<T> type, T ... def) {
        return this.getProperty(key, type, ObjectUtils.firstNonNull(def));
    }

    public final <T> Class<? extends T> getClassProperty(String key, Class<T> type, Class<? extends T> def) {
        return this.getProperty(key, (Class<T>)Class.class, (T)def);
    }

    public <T> T getInstanceProperty(String key, Class<T> type, Object def) {
        return this.newInstance(type, this.getProperty(key), def);
    }

    public <T> T[] getInstanceArrayProperty(String key, Class<T> type, T[] def) {
        Object o = this.getProperty(key);
        Object[] t = null;
        if (o == null) {
            t = def;
        } else if (o.getClass().isArray()) {
            if (o.getClass().getComponentType() == type) {
                t = (Object[])o;
            } else {
                t = (Object[])Array.newInstance(type, Array.getLength(o));
                for (int i = 0; i < Array.getLength(o); ++i) {
                    t[i] = this.newInstance(type, Array.get(o, i), null);
                }
            }
        } else if (o instanceof Collection) {
            Collection c = (Collection)o;
            t = (Object[])Array.newInstance(type, c.size());
            int i = 0;
            for (Object o2 : c) {
                t[i++] = this.newInstance(type, o2, null);
            }
        }
        if (t != null) {
            return t;
        }
        throw new ConfigException("Could not instantiate property ''{0}'' as type {1}", key, type);
    }

    protected OMap getProperties() {
        return this.properties;
    }

    public Set<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    private <T> T newInstance(Class<T> type, Object o, Object def) {
        Object t = null;
        if (o == null) {
            if (def == null) {
                return null;
            }
            t = ClassUtils.castOrCreate(type, def);
        } else if (type.isInstance(o)) {
            t = o;
        } else if (o.getClass() == Class.class) {
            t = ClassUtils.castOrCreate(type, o);
        } else if (o.getClass() == String.class) {
            t = ClassUtils.fromString(type, o.toString());
        }
        if (t != null) {
            return (T)t;
        }
        throw new ConfigException("Could not instantiate type ''{0}'' as type {1}", o, type);
    }

    public final void addToCache(String key, Object val) {
        if (this.cache == null) {
            this.cache = new TreeMap<String, Object>();
        }
        this.cache.put(key, val);
    }

    public final void addToCache(Map<String, Object> cacheObjects) {
        if (cacheObjects != null) {
            if (this.cache == null) {
                this.cache = new TreeMap<String, Object>();
            }
            this.cache.putAll(cacheObjects);
        }
    }

    public final <T> T getFromCache(Class<T> c, String key) {
        return (T)(this.cache == null ? null : this.cache.get(key));
    }

    public void addWarning(String msg, Object ... args) {
        if (this.warnings == null) {
            this.warnings = new LinkedList<String>();
        }
        this.warnings.add(this.warnings.size() + 1 + ": " + StringUtils.format(msg, args));
    }

    public final boolean hasWarnings() {
        return this.warnings != null && this.warnings.size() > 0;
    }

    public final List<String> getWarnings() {
        return this.warnings;
    }

    public void checkForWarnings() {
        if (this.warnings != null && !this.warnings.isEmpty()) {
            throw new BeanRuntimeException("Warnings occurred in session: \n" + StringUtils.join(this.getWarnings(), "\n"));
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final MediaType getMediaType() {
        return this.mediaType;
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    public final ZoneId getTimeZoneId() {
        return this.timeZone == null ? ZoneId.systemDefault() : this.timeZone.toZoneId();
    }

    public OMap toMap() {
        return new DefaultFilteringOMap();
    }

    public String toString() {
        return SimpleJsonSerializer.DEFAULT_READABLE.toString(this.toMap());
    }
}

