/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;

@FluentSetters(returns="FluentObjectAssertion<R>")
public class FluentObjectAssertion<R>
extends FluentAssertion<R> {
    private final Object value;
    private static JsonSerializer JSON = JsonSerializer.create().ssq().build();
    private static JsonSerializer JSON_SORTED = JsonSerializer.create().ssq().sortProperties().sortCollections().sortMaps().build();

    public FluentObjectAssertion(Object value, R returns) {
        this(null, value, returns);
    }

    public FluentObjectAssertion(Assertion creator, Object value, R returns) {
        super(creator, returns);
        this.value = value;
    }

    public R isType(Class<?> parent) throws AssertionError {
        this.exists();
        this.assertNotNull("parent", parent);
        if (!ClassInfo.of(this.value).isChildOf(parent)) {
            throw this.error("Unexpected class.\n\tExpected=[{0}]\n\tActual=[{1}]", FluentObjectAssertion.className(parent), FluentObjectAssertion.className(this.value));
        }
        return this.returns();
    }

    public FluentStringAssertion<R> serialized(WriterSerializer ws) {
        try {
            String s = ws.serialize(this.value);
            return new FluentStringAssertion((Assertion)this, s, this.returns());
        }
        catch (SerializeException e) {
            throw new RuntimeException(e);
        }
    }

    public FluentStringAssertion<R> string() {
        return new FluentStringAssertion((Assertion)this, this.value == null ? null : this.value.toString(), this.returns());
    }

    public FluentStringAssertion<R> string(Function<Object, String> function) {
        return new FluentStringAssertion((Assertion)this, function.apply(this.value), this.returns());
    }

    public <T> FluentStringAssertion<R> string(Class<T> c, Function<T, String> function) {
        return new FluentStringAssertion((Assertion)this, function.apply(this.value), this.returns());
    }

    public FluentStringAssertion<R> json() {
        return this.serialized(JSON);
    }

    public FluentStringAssertion<R> jsonSorted() {
        return this.serialized(JSON_SORTED);
    }

    public R sameAs(Object o) throws AssertionError {
        return this.sameAsSerialized(o, JSON);
    }

    public R sameAsSorted(Object o) {
        return this.sameAsSerialized(o, JSON_SORTED);
    }

    public R sameAsSerialized(Object o, WriterSerializer serializer) {
        try {
            String s1 = serializer.serialize(this.value);
            String s2 = serializer.serialize(o);
            if (!StringUtils.isEquals(s1, s2)) {
                throw this.error("Unexpected comparison.\n\tExpected=[{0}]\n\tActual=[{1}]", s2, s1);
            }
        }
        catch (SerializeException e) {
            throw new RuntimeException(e);
        }
        return this.returns();
    }

    public R isEqual(Object value) throws AssertionError {
        if (this.value == value) {
            return this.returns();
        }
        this.exists();
        if (!this.value.equals(this.equivalent(value))) {
            throw this.error("Unexpected value.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R is(Object value) throws AssertionError {
        return this.isEqual(this.equivalent(value));
    }

    public R doesNotEqual(Object value) throws AssertionError {
        if (this.value == null && value != null || this.value != null && value == null) {
            return this.returns();
        }
        if (this.value == null || this.value.equals(this.equivalent(value))) {
            throw this.error("Unexpected value.\n\tExpected not=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R passes(Predicate<Object> test) throws AssertionError {
        if (!test.test(this.value)) {
            throw this.error("Value did not pass predicate test.\n\tValue=[{0}]", this.value);
        }
        return this.returns();
    }

    public <T> R passes(Class<T> c, Predicate<T> test) throws AssertionError {
        this.isType(c);
        if (!test.test(this.value)) {
            throw this.error("Value did not pass predicate test.\n\tValue=[{0}]", this.value);
        }
        return this.returns();
    }

    public R exists() throws AssertionError {
        return this.isNotNull();
    }

    public R doesNotExist() throws AssertionError {
        return this.isNull();
    }

    public R isNotNull() throws AssertionError {
        if (this.value == null) {
            throw this.error("Value was null.", new Object[0]);
        }
        return this.returns();
    }

    public R isNull() throws AssertionError {
        if (this.value != null) {
            throw this.error("Value was not null.", new Object[0]);
        }
        return this.returns();
    }

    public R isNot(Object value) throws AssertionError {
        return this.doesNotEqual(this.equivalent(value));
    }

    public R isAny(Object ... values) throws AssertionError {
        this.exists();
        for (Object v : values) {
            if (!this.value.equals(this.equivalent(v))) continue;
            return this.returns();
        }
        throw this.error("Expected value not found.\n\tExpected=[{0}]\n\tActual=[{1}]", SimpleJson.DEFAULT.toString(values), this.value);
    }

    public R isNotAny(Object ... values) throws AssertionError {
        this.exists();
        for (Object v : values) {
            if (!this.value.equals(this.equivalent(v))) continue;
            throw this.error("Unexpected value found.\n\tUnexpected=[{0}]\n\tActual=[{1}]", v, this.value);
        }
        return this.returns();
    }

    protected Object equivalent(Object o) {
        return o;
    }

    @Override
    public FluentObjectAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentObjectAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentObjectAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

