/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.Context;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Session;
import org.apache.juneau.SessionArgs;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.store.ConfigStoreListener;

@ConfigurableContext
public abstract class ConfigStore
extends Context
implements Closeable {
    static final String PREFIX = "ConfigStore";
    private final ConcurrentHashMap<String, Set<ConfigStoreListener>> listeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConfigMap> configMaps = new ConcurrentHashMap();

    protected ConfigStore(PropertyStore ps) {
        super(ps, false);
    }

    public abstract String read(String var1) throws IOException;

    public abstract String write(String var1, String var2, String var3) throws IOException;

    public abstract boolean exists(String var1);

    public synchronized ConfigStore register(String name, ConfigStoreListener l) {
        Set<ConfigStoreListener> s = this.listeners.get(name = this.resolveName(name));
        if (s == null) {
            s = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
            this.listeners.put(name, s);
        }
        s.add(l);
        return this;
    }

    public synchronized ConfigStore unregister(String name, ConfigStoreListener l) {
        Set<ConfigStoreListener> s = this.listeners.get(name = this.resolveName(name));
        if (s != null) {
            s.remove(l);
        }
        return this;
    }

    public synchronized ConfigMap getMap(String name) throws IOException {
        ConfigMap cm = this.configMaps.get(name = this.resolveName(name));
        if (cm != null) {
            return cm;
        }
        cm = new ConfigMap(this, name);
        ConfigMap cm2 = this.configMaps.putIfAbsent(name, cm);
        if (cm2 != null) {
            return cm2;
        }
        this.register(name, cm);
        return cm;
    }

    public synchronized ConfigStore update(String name, String contents) {
        Set<ConfigStoreListener> s = this.listeners.get(name = this.resolveName(name));
        if (s != null) {
            for (ConfigStoreListener l : this.listeners.get(name)) {
                l.onChange(contents);
            }
        }
        return this;
    }

    public synchronized ConfigStore update(String name, String ... contentLines) {
        name = this.resolveName(name);
        StringBuilder sb = new StringBuilder();
        for (String l : contentLines) {
            sb.append(l).append('\n');
        }
        return this.update(name, sb.toString());
    }

    protected String resolveName(String name) {
        return name;
    }

    @Override
    public final Session createSession(SessionArgs args) {
        throw new NoSuchMethodError();
    }

    @Override
    public final SessionArgs createDefaultSessionArgs() {
        throw new NoSuchMethodError();
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap());
    }
}

