/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.cp.BasicResourceFinder;
import org.apache.juneau.cp.ResourceFinder;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;

public final class ResourceManager {
    private final ConcurrentHashMap<ResourceKey, byte[]> byteCache;
    private final ConcurrentHashMap<ResourceKey, String> stringCache;
    private final Class<?> baseClass;
    private final ResourceFinder resourceFinder;
    private final boolean useCache;

    public ResourceManager(Class<?> baseClass, ResourceFinder resourceFinder, boolean useCache) {
        this.baseClass = baseClass;
        this.resourceFinder = resourceFinder;
        this.useCache = useCache;
        if (useCache) {
            this.byteCache = new ConcurrentHashMap();
            this.stringCache = new ConcurrentHashMap();
        } else {
            this.byteCache = null;
            this.stringCache = null;
        }
    }

    public ResourceManager(Class<?> baseClass) {
        this(baseClass, BasicResourceFinder.INSTANCE, false);
    }

    public InputStream getStream(String name) throws IOException {
        return this.getStream(name, null);
    }

    public InputStream getStream(String name, Locale locale) throws IOException {
        if (ObjectUtils.isEmpty(name)) {
            return null;
        }
        if (!this.useCache) {
            return this.resourceFinder.findResource(this.baseClass, name, locale);
        }
        ResourceKey key = new ResourceKey(name, locale);
        byte[] r = this.byteCache.get(key);
        if (r == null) {
            try (InputStream is = this.resourceFinder.findResource(this.baseClass, name, locale);){
                if (is != null) {
                    this.byteCache.putIfAbsent(key, IOUtils.readBytes(is, 1024));
                }
            }
        }
        return (r = this.byteCache.get(key)) == null ? null : new ByteArrayInputStream(r);
    }

    public String getString(String name) throws IOException {
        return this.getString(name, null);
    }

    public String getString(String name, Locale locale) throws IOException {
        if (ObjectUtils.isEmpty(name)) {
            return null;
        }
        if (!this.useCache) {
            try (InputStream is = this.resourceFinder.findResource(this.baseClass, name, locale);){
                String string = IOUtils.read(is, IOUtils.UTF8);
                return string;
            }
        }
        ResourceKey key = new ResourceKey(name, locale);
        String r = this.stringCache.get(key);
        if (r == null) {
            try (InputStream is = this.resourceFinder.findResource(this.baseClass, name, locale);){
                if (is != null) {
                    this.stringCache.putIfAbsent(key, IOUtils.read(is, IOUtils.UTF8));
                }
            }
        }
        return this.stringCache.get(key);
    }

    public <T> T getResource(Class<T> c, Parser parser, String name) throws IOException, ParseException {
        return this.getResource(c, parser, name, null);
    }

    public <T> T getResource(Class<T> c, Parser parser, String name, Locale locale) throws IOException, ParseException {
        InputStream is = this.getStream(name, locale);
        if (is == null) {
            return null;
        }
        try (Closeable in = parser.isReaderParser() ? new InputStreamReader(is, IOUtils.UTF8) : is;){
            T t = parser.parse((Object)in, c);
            return t;
        }
    }

    private class ResourceKey {
        final String name;
        final Locale locale;

        ResourceKey(String name, Locale locale) {
            this.name = name;
            this.locale = locale;
        }

        public int hashCode() {
            return this.name.hashCode() + (this.locale == null ? 0 : this.locale.hashCode());
        }

        public boolean equals(Object o) {
            return ObjectUtils.eq(this, (ResourceKey)o, (x, y) -> ObjectUtils.eq(x.name, y.name) && ObjectUtils.eq(x.locale, y.locale));
        }
    }
}

