/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.BasicNameValuePair;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public class StringRange {
    private final NameValuePair[] extensions;
    private final Float qValue;
    private final String name;
    private final String string;

    public StringRange(String value) {
        this(StringRange.parse(value));
    }

    public StringRange(HeaderElement e) {
        Float qValue = Float.valueOf(1.0f);
        AList<NameValuePair> extensions = AList.of();
        for (NameValuePair p : e.getParameters()) {
            if (p.getName().equals("q")) {
                qValue = Float.valueOf(Float.parseFloat(p.getValue()));
                continue;
            }
            extensions.add(BasicNameValuePair.of(p.getName(), p.getValue()));
        }
        this.qValue = qValue;
        this.extensions = extensions.toArray(new NameValuePair[extensions.size()]);
        this.name = e.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (Float.compare(qValue.floatValue(), 1.0f) == 0) {
            if (this.extensions.length > 0) {
                sb.append(";q=").append(qValue);
                for (NameValuePair p : extensions) {
                    sb.append(';').append(p.getName()).append('=').append(p.getValue());
                }
            }
        } else {
            sb.append(";q=").append(qValue);
            for (NameValuePair p : extensions) {
                sb.append(';').append(p.getName()).append('=').append(p.getValue());
            }
        }
        this.string = sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public Float getQValue() {
        return this.qValue;
    }

    public List<NameValuePair> getExtensions() {
        return Collections.unmodifiableList(Arrays.asList(this.extensions));
    }

    public boolean equals(Object o) {
        return o instanceof StringRange && ObjectUtils.eq(this, (StringRange)o, (x, y) -> ObjectUtils.eq(x.string, y.string));
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public int match(String name) {
        if (this.qValue.floatValue() == 0.0f) {
            return 0;
        }
        if (ObjectUtils.eq(this.name, name)) {
            return 100;
        }
        if (ObjectUtils.eq(this.name, "*")) {
            return 50;
        }
        return 0;
    }

    private static HeaderElement parse(String value) {
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)StringUtils.emptyIfNull(StringUtils.trim(value)), null);
        return elements.length > 0 ? elements[0] : new BasicHeaderElement("*", "");
    }

    public String toString() {
        return this.string;
    }
}

