/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.ContextCache;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.transform.BeanInterceptor;

public class ParserGroupBuilder
extends BeanContextBuilder {
    private final AList<Object> parsers;

    public ParserGroupBuilder() {
        this.parsers = AList.of();
    }

    public ParserGroupBuilder(ParserGroup copyFrom) {
        super(copyFrom.getPropertyStore());
        this.parsers = AList.of().arev(copyFrom.getParsers());
    }

    public ParserGroupBuilder append(Class<?> ... p) {
        this.parsers.arev(p);
        return this;
    }

    public ParserGroupBuilder append(Parser ... p) {
        this.parsers.arev((Object[])p);
        return this;
    }

    public ParserGroupBuilder append(List<Object> p) {
        this.parsers.arev(p);
        return this;
    }

    public ParserGroupBuilder append(Object ... p) {
        this.parsers.arev((Object[])p);
        return this;
    }

    @Override
    public ParserGroup build() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object e : this.parsers) {
            Class c = null;
            PropertyStore ps = this.getPropertyStore();
            if (e instanceof Class) {
                c = (Class)e;
                l.add(ContextCache.INSTANCE.create(c, ps));
                continue;
            }
            l.add((Parser)e);
        }
        return new ParserGroup(this.getPropertyStore(), ArrayUtils.toReverseArray(Parser.class, l));
    }

    public ParserGroupBuilder autoCloseStreams(boolean value) {
        return this.set("Parser.autoCloseStreams.b", value);
    }

    public ParserGroupBuilder autoCloseStreams() {
        return this.set("Parser.autoCloseStreams.b", true);
    }

    public ParserGroupBuilder debugOutputLines(int value) {
        this.set("Parser.debugOutputLines.i", value);
        return this;
    }

    public ParserGroupBuilder listener(Class<? extends ParserListener> value) {
        return this.set("Parser.listener.c", value);
    }

    public ParserGroupBuilder strict(boolean value) {
        return this.set("Parser.strict.b", value);
    }

    public ParserGroupBuilder strict() {
        return this.set("Parser.strict.b", true);
    }

    public ParserGroupBuilder trimStrings(boolean value) {
        return this.set("Parser.trimStrings.b", value);
    }

    public ParserGroupBuilder trimStrings() {
        return this.set("Parser.trimStrings.b", true);
    }

    public ParserGroupBuilder unbuffered(boolean value) {
        return this.set("Parser.unbuffered.b", value);
    }

    public ParserGroupBuilder unbuffered() {
        return this.set("Parser.unbuffered.b", true);
    }

    public ParserGroupBuilder fileCharset(Charset value) {
        return this.set("ReaderParser.fileCharset.s", value);
    }

    public ParserGroupBuilder streamCharset(Charset value) {
        return this.set("ReaderParser.streamCharset.s", value);
    }

    public ParserGroupBuilder binaryFormat(BinaryFormat value) {
        return this.set("InputStreamParser.binaryFormat.s", (Object)value);
    }

    @Override
    public ParserGroupBuilder add(Map<String, Object> properties) {
        super.add((Map)properties);
        return this;
    }

    @Override
    public ParserGroupBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public ParserGroupBuilder appendTo(String name, Object value) {
        super.appendTo(name, value);
        return this;
    }

    @Override
    public ParserGroupBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public ParserGroupBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    @Override
    public ParserGroupBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }

    @Override
    public ParserGroupBuilder applyAnnotations(AnnotationList al, VarResolverSession r) {
        super.applyAnnotations(al, r);
        return this;
    }

    @Override
    public ParserGroupBuilder debug() {
        super.debug();
        return this;
    }

    @Override
    public ParserGroupBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public ParserGroupBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public ParserGroupBuilder prependTo(String name, Object value) {
        super.prependTo(name, value);
        return this;
    }

    @Override
    public ParserGroupBuilder putAllTo(String name, Object value) {
        super.putAllTo(name, value);
        return this;
    }

    @Override
    public ParserGroupBuilder putTo(String name, String key, Object value) {
        super.putTo(name, key, value);
        return this;
    }

    @Override
    public ParserGroupBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public ParserGroupBuilder set(Map<String, Object> properties) {
        super.set((Map)properties);
        return this;
    }

    @Override
    public ParserGroupBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public ParserGroupBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    @Override
    public ParserGroupBuilder annotations(Annotation ... values) {
        super.annotations(values);
        return this;
    }

    @Override
    public ParserGroupBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
        super.beanInterceptor(on, value);
        return this;
    }

    @Override
    public ParserGroupBuilder beanMapPutReturnsOldValue() {
        super.beanMapPutReturnsOldValue();
        return this;
    }

    @Override
    public ParserGroupBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    @Override
    public ParserGroupBuilder beansDontRequireSomeProperties() {
        super.beansDontRequireSomeProperties();
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    @Override
    public ParserGroupBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    @Override
    public ParserGroupBuilder bpi(Map<String, Object> values) {
        super.bpi(values);
        return this;
    }

    @Override
    public ParserGroupBuilder bpi(Class<?> beanClass, String properties) {
        super.bpi(beanClass, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder bpi(String beanClassName, String properties) {
        super.bpi(beanClassName, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder bpro(Map<String, Object> values) {
        super.bpro(values);
        return this;
    }

    @Override
    public ParserGroupBuilder bpro(Class<?> beanClass, String properties) {
        super.bpro(beanClass, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder bpro(String beanClassName, String properties) {
        super.bpro(beanClassName, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder bpwo(Map<String, Object> values) {
        super.bpwo(values);
        return this;
    }

    @Override
    public ParserGroupBuilder bpwo(Class<?> beanClass, String properties) {
        super.bpwo(beanClass, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder bpwo(String beanClassName, String properties) {
        super.bpwo(beanClassName, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder bpx(Map<String, Object> values) {
        super.bpx(values);
        return this;
    }

    @Override
    public ParserGroupBuilder bpx(Class<?> beanClass, String properties) {
        super.bpx(beanClass, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder bpx(String beanClassName, String properties) {
        super.bpx(beanClassName, properties);
        return this;
    }

    @Override
    public ParserGroupBuilder dictionary(Object ... values) {
        super.dictionary(values);
        return this;
    }

    @Override
    public ParserGroupBuilder dictionaryOn(Class<?> on, Class<?> ... values) {
        super.dictionaryOn(on, values);
        return this;
    }

    @Override
    public ParserGroupBuilder dontIgnorePropertiesWithoutSetters() {
        super.dontIgnorePropertiesWithoutSetters();
        return this;
    }

    @Override
    public ParserGroupBuilder dontIgnoreTransientFields() {
        super.dontIgnoreTransientFields();
        return this;
    }

    @Override
    public ParserGroupBuilder dontIgnoreUnknownNullBeanProperties() {
        super.dontIgnoreUnknownNullBeanProperties();
        return this;
    }

    @Override
    public ParserGroupBuilder dontUseInterfaceProxies() {
        super.dontUseInterfaceProxies();
        return this;
    }

    @Override
    public <T> ParserGroupBuilder example(Class<T> pojoClass, T o) {
        super.example(pojoClass, o);
        return this;
    }

    @Override
    public <T> ParserGroupBuilder exampleJson(Class<T> pojoClass, String json) {
        super.exampleJson(pojoClass, json);
        return this;
    }

    @Override
    public ParserGroupBuilder fluentSetters() {
        super.fluentSetters();
        return this;
    }

    @Override
    public ParserGroupBuilder fluentSetters(Class<?> on) {
        super.fluentSetters(on);
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    @Override
    public ParserGroupBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    @Override
    public ParserGroupBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    @Override
    public ParserGroupBuilder implClasses(Map<Class<?>, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    @Override
    public ParserGroupBuilder interfaceClass(Class<?> on, Class<?> value) {
        super.interfaceClass(on, value);
        return this;
    }

    @Override
    public ParserGroupBuilder interfaces(Class<?> ... value) {
        super.interfaces(value);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public ParserGroupBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public ParserGroupBuilder propertyNamer(Class<? extends PropertyNamer> value) {
        super.propertyNamer(value);
        return this;
    }

    @Override
    public ParserGroupBuilder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
        super.propertyNamer(on, value);
        return this;
    }

    @Override
    public ParserGroupBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    @Override
    public ParserGroupBuilder sortProperties(Class<?> ... on) {
        super.sortProperties(on);
        return this;
    }

    @Override
    public ParserGroupBuilder stopClass(Class<?> on, Class<?> value) {
        super.stopClass(on, value);
        return this;
    }

    @Override
    public ParserGroupBuilder swaps(Object ... values) {
        super.swaps(values);
        return this;
    }

    @Override
    public ParserGroupBuilder typeName(Class<?> on, String value) {
        super.typeName(on, value);
        return this;
    }

    @Override
    public ParserGroupBuilder typePropertyName(String value) {
        super.typePropertyName(value);
        return this;
    }

    @Override
    public ParserGroupBuilder typePropertyName(Class<?> on, String value) {
        super.typePropertyName(on, value);
        return this;
    }

    @Override
    public ParserGroupBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    @Override
    public ParserGroupBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }
}

