/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.reshandlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.http.exception.NotAcceptable;
import org.apache.juneau.http.header.ContentLength;
import org.apache.juneau.httppart.HttpPart;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.util.FinishablePrintWriter;
import org.apache.juneau.rest.util.FinishableServletOutputStream;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.utils.IOPipe;

public class DefaultHandler
implements ResponseHandler {
    @Override
    public boolean handle(RestRequest req, RestResponse res) throws IOException, InternalServerError, NotAcceptable {
        SerializerGroup g = res.getSerializers();
        String accept = req.getHeaders().getString("Accept", "*/*");
        SerializerMatch sm = g.getSerializerMatch(accept);
        HttpPartSchema schema = null;
        Object o = res.getOutput();
        ResponseBeanMeta rm = res.getResponseMeta();
        if (rm == null) {
            rm = req.getResponseBeanMeta(o);
        }
        if (rm != null) {
            ResponseBeanPropertyMeta stm;
            boolean isThrowable = rm.getClassMeta().isType(Throwable.class);
            if (isThrowable) {
                res.setHeaderSafe("Exception-Name", rm.getClassMeta().getName());
                res.setHeaderSafe("Exception-Message", ((Throwable)o).getMessage());
                if (req.isDebug()) {
                    ((Throwable)o).printStackTrace();
                }
            }
            if ((stm = rm.getStatusMethod()) != null) {
                try {
                    res.setStatus((Integer)stm.getGetter().invoke(o, new Object[0]));
                }
                catch (Exception e) {
                    throw new InternalServerError((Throwable)e, "Could not get status.", new Object[0]);
                }
            } else if (rm.getCode() != 0) {
                res.setStatus(rm.getCode());
            }
            for (ResponseBeanPropertyMeta hm : rm.getHeaderMethods()) {
                try {
                    Object ho = hm.getGetter().invoke(o, new Object[0]);
                    String string = hm.getPartName();
                    if ("*".equals(string)) {
                        for (Object ho2 : this.iterate(ho)) {
                            if (ho2 instanceof Map.Entry) {
                                Map.Entry e = (Map.Entry)ho2;
                                String k = StringUtils.stringify(e.getKey());
                                Object v = e.getValue();
                                HttpPartSchema s = hm.getSchema().getProperty(k);
                                res.setHeader(new HttpPart(k, HttpPartType.RESPONSE_HEADER, s, hm.getSerializer(req.getPartSerializer()), v));
                                continue;
                            }
                            if (ho2 instanceof NameValuePair) {
                                NameValuePair p = (NameValuePair)ho2;
                                res.setHeader(p.getName(), p.getValue());
                                continue;
                            }
                            throw new InternalServerError("Invalid type ''{0}'' for header ''{1}''", hm.getPartName(), ho2 == null ? null : ho2.getClass().getName());
                        }
                        continue;
                    }
                    if (ho instanceof NameValuePair) {
                        NameValuePair p = (NameValuePair)ho;
                        res.setHeader(p.getName(), p.getValue());
                        continue;
                    }
                    res.setHeader(new HttpPart(string, HttpPartType.RESPONSE_HEADER, hm.getSchema(), hm.getSerializer(req.getPartSerializer()), ho));
                }
                catch (Exception e) {
                    throw new InternalServerError((Throwable)e, "Could not set header ''{0}''", hm.getPartName());
                }
            }
            ResponseBeanPropertyMeta bm = rm.getBodyMethod();
            if (bm != null) {
                Method m = bm.getGetter();
                try {
                    Class<?>[] pt = m.getParameterTypes();
                    if (pt.length == 1) {
                        Class<?> clazz = pt[0];
                        if (clazz == OutputStream.class) {
                            m.invoke(o, res.getOutputStream());
                        } else if (clazz == Writer.class) {
                            m.invoke(o, res.getWriter());
                        }
                        return true;
                    }
                    o = m.invoke(o, new Object[0]);
                }
                catch (Exception e2) {
                    throw new InternalServerError((Throwable)e2, "Could not get body.", new Object[0]);
                }
            }
            schema = rm.getSchema();
        }
        if (o instanceof HttpEntity) {
            HttpEntity e = (HttpEntity)o;
            res.header((NameValuePair)e.getContentType()).header((NameValuePair)e.getContentEncoding());
            long contentLength = e.getContentLength();
            if (contentLength >= 0L) {
                res.header((NameValuePair)ContentLength.of(contentLength));
            }
            FinishableServletOutputStream os = res.getNegotiatedOutputStream();
            Object e2 = null;
            try {
                e.writeTo((OutputStream)((Object)os));
                ((OutputStream)((Object)os)).flush();
            }
            catch (Throwable throwable) {
                e2 = throwable;
                throw throwable;
            }
            finally {
                if (os != null) {
                    if (e2 != null) {
                        try {
                            ((OutputStream)((Object)os)).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)e2).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)((Object)os)).close();
                    }
                }
            }
            return true;
        }
        if (sm != null) {
            MediaType responseType;
            Serializer s = sm.getSerializer();
            MediaType mediaType = res.getMediaType();
            if (mediaType == null) {
                mediaType = sm.getMediaType();
            }
            if ((responseType = s.getResponseContentType()) == null) {
                responseType = mediaType;
            }
            res.setContentType(responseType.toString());
            try {
                FinishablePrintWriter w;
                if (req.isPlainText()) {
                    res.setContentType("text/plain");
                }
                SerializerSession session = s.createSession(SerializerSessionArgs.create().properties(req.getAttributes()).javaMethod(req.getJavaMethod()).locale(req.getLocale()).timeZone(req.getHeaders().getTimeZone()).mediaType(mediaType).streamCharset(res.getCharset()).schema(schema).debug(req.isDebug() ? Boolean.valueOf(true) : null).uriContext(req.getUriContext()).useWhitespace(req.isPlainText() ? Boolean.valueOf(true) : null).resolver(req.getVarResolverSession()));
                for (Map.Entry entry : session.getResponseHeaders().entrySet()) {
                    res.setHeaderSafe((String)entry.getKey(), (String)entry.getValue());
                }
                if (!session.isWriterSerializer()) {
                    if (req.isPlainText()) {
                        w = res.getNegotiatedWriter();
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        session.serialize(o, byteArrayOutputStream);
                        w.write(StringUtils.toSpacedHex(byteArrayOutputStream.toByteArray()));
                        w.flush();
                        w.finish();
                    } else {
                        FinishableServletOutputStream os = res.getNegotiatedOutputStream();
                        session.serialize(o, os);
                        os.flush();
                        os.finish();
                    }
                } else {
                    w = res.getNegotiatedWriter();
                    session.serialize(o, w);
                    w.flush();
                    w.finish();
                }
            }
            catch (SerializeException e) {
                throw new InternalServerError(e);
            }
            return true;
        }
        if (o != null && (StringUtils.isEmpty(accept) || accept.startsWith("text/plain") || accept.contains("*/*"))) {
            FinishablePrintWriter w;
            Throwable throwable;
            String out = null;
            if (StringUtils.isEmpty(res.getContentType())) {
                res.setContentType("text/plain");
            }
            if (o instanceof InputStream) {
                throwable = null;
                try (FinishableServletOutputStream os = res.getNegotiatedOutputStream();){
                    IOPipe.create(o, os).run();
                    ((OutputStream)((Object)os)).flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            } else if (o instanceof Reader) {
                w = res.getNegotiatedWriter();
                throwable = null;
                try {
                    IOPipe.create(o, w).run();
                    w.flush();
                    w.finish();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (w != null) {
                        if (throwable != null) {
                            try {
                                w.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            w.close();
                        }
                    }
                }
            } else {
                out = req.getBeanSession().getClassMetaForObject(o).toString(o);
                w = res.getNegotiatedWriter();
                w.append(out);
                w.flush();
                w.finish();
            }
            return true;
        }
        throw new NotAcceptable("Unsupported media-type in request header ''Accept'': ''{0}''\n\tSupported media-types: {1}", req.getHeaders().getString("Accept", ""), g.getSupportedMediaTypes());
    }

    private Iterable<?> iterate(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet();
        }
        if (o.getClass().isArray()) {
            return Arrays.asList(o);
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        throw new InternalServerError("Could not iterate over Headers of type ''{0}''", o.getClass().getName());
    }
}

