/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.IOException;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.MediaRanges;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;

@ConfigurableContext
public abstract class Serializer
extends BeanTraverseContext {
    static final String PREFIX = "Serializer";
    public static final String SERIALIZER_addBeanTypes = "Serializer.addBeanTypes.b";
    public static final String SERIALIZER_addRootType = "Serializer.addRootType.b";
    public static final String SERIALIZER_listener = "Serializer.listener.c";
    public static final String SERIALIZER_keepNullProperties = "Serializer.keepNullProperties.b";
    public static final String SERIALIZER_sortCollections = "Serializer.sortCollections.b";
    public static final String SERIALIZER_sortMaps = "Serializer.sortMaps.b";
    public static final String SERIALIZER_trimEmptyCollections = "Serializer.trimEmptyCollections.b";
    public static final String SERIALIZER_trimEmptyMaps = "Serializer.trimEmptyMaps.b";
    @Deprecated
    public static final String SERIALIZER_trimNullProperties = "Serializer.trimNullProperties.b";
    public static final String SERIALIZER_trimStrings = "Serializer.trimStrings.b";
    public static final String SERIALIZER_uriContext = "Serializer.uriContext.s";
    public static final String SERIALIZER_uriRelativity = "Serializer.uriRelativity.s";
    public static final String SERIALIZER_uriResolution = "Serializer.uriResolution.s";
    static final Serializer DEFAULT = new Serializer(PropertyStore.create().build(), "", ""){

        @Override
        public SerializerSession createSession(SerializerSessionArgs args) {
            throw new NoSuchMethodError();
        }
    };
    private final boolean addBeanTypes = this.getBooleanProperty("Serializer.addBeanTypes.b", false);
    private final boolean keepNullProperties = this.getBooleanProperty("Serializer.keepNullProperties.b", this.getBooleanProperty("Serializer.trimNullProperties.b", true) == false);
    private final boolean trimEmptyCollections = this.getBooleanProperty("Serializer.trimEmptyCollections.b", false);
    private final boolean trimEmptyMaps = this.getBooleanProperty("Serializer.trimEmptyMaps.b", false);
    private final boolean trimStrings = this.getBooleanProperty("Serializer.trimStrings.b", false);
    private final boolean sortCollections = this.getBooleanProperty("Serializer.sortCollections.b", false);
    private final boolean sortMaps = this.getBooleanProperty("Serializer.sortMaps.b", false);
    private final boolean addRootType = this.getBooleanProperty("Serializer.addRootType.b", false);
    private final UriContext uriContext = this.getProperty("Serializer.uriContext.s", UriContext.class, UriContext.DEFAULT);
    private final UriResolution uriResolution = this.getProperty("Serializer.uriResolution.s", UriResolution.class, UriResolution.NONE);
    private final UriRelativity uriRelativity = this.getProperty("Serializer.uriRelativity.s", UriRelativity.class, UriRelativity.RESOURCE);
    private final Class<? extends SerializerListener> listener = this.getClassProperty("Serializer.listener.c", SerializerListener.class, null);
    private final MediaRanges accept;
    private final MediaType[] accepts;
    private final MediaType produces;

    protected Serializer(PropertyStore ps, String produces, String accept) {
        super(ps);
        MediaType[] mediaTypeArray;
        this.produces = MediaType.of(produces);
        MediaRanges mediaRanges = this.accept = accept == null ? MediaRanges.of(produces) : MediaRanges.of(accept);
        if (accept == null) {
            MediaType[] mediaTypeArray2 = new MediaType[1];
            mediaTypeArray = mediaTypeArray2;
            mediaTypeArray2[0] = this.produces;
        } else {
            mediaTypeArray = MediaType.ofAll(StringUtils.split(accept, ','));
        }
        this.accepts = mediaTypeArray;
    }

    @Override
    public SerializerBuilder builder() {
        return null;
    }

    public boolean isWriterSerializer() {
        return true;
    }

    public abstract SerializerSession createSession(SerializerSessionArgs var1);

    @Override
    public SerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public final SerializerSessionArgs createDefaultSessionArgs() {
        return new SerializerSessionArgs().mediaType(this.getResponseContentType());
    }

    public final void serialize(Object o, Object output) throws SerializeException, IOException {
        this.createSession().serialize(o, output);
    }

    public Object serialize(Object o) throws SerializeException {
        return this.createSession().serialize(o);
    }

    public final String serializeToString(Object o) throws SerializeException {
        return this.createSession().serializeToString(o);
    }

    public final MediaRanges getMediaTypeRanges() {
        return this.accept;
    }

    public final MediaType getPrimaryMediaType() {
        return this.accepts[0];
    }

    public final MediaType[] getAcceptMediaTypes() {
        return this.accepts;
    }

    public final MediaType getResponseContentType() {
        return this.produces;
    }

    protected boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isAddRootType() {
        return this.addRootType;
    }

    protected final Class<? extends SerializerListener> getListener() {
        return this.listener;
    }

    protected final boolean isSortCollections() {
        return this.sortCollections;
    }

    protected final boolean isSortMaps() {
        return this.sortMaps;
    }

    protected final boolean isTrimEmptyCollections() {
        return this.trimEmptyCollections;
    }

    protected final boolean isTrimEmptyMaps() {
        return this.trimEmptyMaps;
    }

    protected final boolean isKeepNullProperties() {
        return this.keepNullProperties;
    }

    protected final boolean isTrimStrings() {
        return this.trimStrings;
    }

    protected final UriContext getUriContext() {
        return this.uriContext;
    }

    protected final UriRelativity getUriRelativity() {
        return this.uriRelativity;
    }

    protected final UriResolution getUriResolution() {
        return this.uriResolution;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("addBeanTypes", this.addBeanTypes).a("keepNullProperties", this.keepNullProperties).a("trimEmptyCollections", this.trimEmptyCollections).a("trimEmptyMaps", this.trimEmptyMaps).a("trimStrings", this.trimStrings).a("sortCollections", this.sortCollections).a("sortMaps", this.sortMaps).a("addRootType", this.addRootType).a("uriContext", this.uriContext).a("uriResolution", (Object)this.uriResolution).a("uriRelativity", (Object)this.uriRelativity).a("listener", this.listener));
    }

    public static abstract class Null
    extends Serializer {
        private Null(PropertyStore ps, String produces, String accept) {
            super(ps, produces, accept);
        }
    }
}

