/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.WriterSerializer;

public final class ASet<T>
extends LinkedHashSet<T> {
    private static final long serialVersionUID = 1L;

    public ASet() {
    }

    public ASet(Collection<T> c) {
        super(c == null ? Collections.emptySet() : c);
    }

    @SafeVarargs
    public static <T> ASet<T> of(T ... t) {
        return new ASet<T>().a(t);
    }

    public static <T> ASet<T> of(Collection<T> c) {
        return new ASet<T>().aa(c);
    }

    public static <T> Set<T> unmodifiable(T ... t) {
        return t.length == 0 ? Collections.emptySet() : ASet.of(t).unmodifiable();
    }

    public static <T> Set<T> unmodifiable(Collection<T> c) {
        if (c == null || c.isEmpty()) {
            return Collections.emptySet();
        }
        return new ASet<T>().aa(c).unmodifiable();
    }

    public ASet<T> a(T t) {
        this.add(t);
        return this;
    }

    public ASet<T> a(T ... t) {
        Collections.addAll(this, t);
        return this;
    }

    public ASet<T> aa(Collection<? extends T> c) {
        if (c != null) {
            this.addAll(c);
        }
        return this;
    }

    public ASet<T> aif(boolean b, T t) {
        if (b) {
            this.a(t);
        }
        return this;
    }

    public ASet<T> aifnn(T ... t) {
        for (T o2 : t) {
            if (o2 == null) continue;
            this.a(o2);
        }
        return this;
    }

    public Set<T> unmodifiable() {
        return this.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this);
    }

    public <T2> T2[] asArrayOf(Class<T2> c) {
        return this.toArray((Object[])Array.newInstance(c, this.size()));
    }

    public String asString(WriterSerializer ws) {
        return ws.toString(this);
    }

    public String asString() {
        return SimpleJsonSerializer.DEFAULT.toString(this);
    }

    @Override
    public String toString() {
        return this.asString(SimpleJsonSerializer.DEFAULT);
    }
}

