/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;

public abstract class WriterSerializerSession
extends SerializerSession {
    private final WriterSerializer ctx;
    private final boolean useWhitespace;
    private final Charset streamCharset;
    private final Charset fileCharset;

    protected WriterSerializerSession(WriterSerializer ctx, SerializerSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
        this.streamCharset = this.getProperty("WriterSerializer.streamCharset.s", Charset.class, ctx.getStreamCharset());
        this.fileCharset = this.getProperty("WriterSerializer.fileCharset.s", Charset.class, ctx.getFileCharset());
        this.useWhitespace = this.getProperty("WriterSerializer.useWhitespace.b", Boolean.class, Boolean.valueOf(ctx.isUseWhitespace()));
    }

    protected WriterSerializerSession(SerializerSessionArgs args) {
        this(WriterSerializer.DEFAULT, args);
    }

    @Override
    public final boolean isWriterSerializer() {
        return true;
    }

    @Override
    protected SerializerPipe createPipe(Object output) {
        return new SerializerPipe(output, this.streamCharset, this.fileCharset);
    }

    @Override
    public final String serialize(Object o) throws SerializeException {
        StringWriter w = new StringWriter();
        try {
            this.serialize(o, w);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return w.toString();
    }

    @Override
    public final String serializeToString(Object o) throws SerializeException {
        return this.serialize(o);
    }

    protected final int getMaxIndent() {
        return this.ctx.getMaxIndent();
    }

    protected char getQuoteChar() {
        return this.ctx.getQuoteChar();
    }

    protected final boolean isUseWhitespace() {
        return this.useWhitespace;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a("WriterSerializerSession", new DefaultFilteringOMap());
    }
}

