/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger.ui;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanSession;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.cp.BasicResourceFinder;
import org.apache.juneau.cp.ResourceFinder;
import org.apache.juneau.cp.ResourceManager;
import org.apache.juneau.dto.html5.Div;
import org.apache.juneau.dto.html5.HtmlBuilder;
import org.apache.juneau.dto.html5.HtmlElement;
import org.apache.juneau.dto.html5.Select;
import org.apache.juneau.dto.html5.Table;
import org.apache.juneau.dto.html5.Td;
import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.OperationMap;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.PojoSwap;

public class SwaggerUI
extends PojoSwap<Swagger, Div> {
    private static final String PREFIX = "SwaggerUI.";
    public static final String SWAGGERUI_resolveRefsMaxDepth = "SwaggerUI.resolveRefsMaxDepth.i";
    static final ResourceManager RESOURCES = new ResourceManager(SwaggerUI.class, (ResourceFinder)BasicResourceFinder.INSTANCE, Boolean.getBoolean("RestContext.useClasspathResourceCaching.b"));
    private static final Set<String> STANDARD_METHODS = ASet.of((Object[])new String[]{"get", "put", "post", "delete", "options"});

    public MediaType[] forMediaTypes() {
        return new MediaType[]{MediaType.HTML};
    }

    public Div swap(BeanSession beanSession, Swagger swagger) throws Exception {
        Session s = new Session(beanSession, swagger);
        String css = RESOURCES.getString("files/htdocs/styles/SwaggerUI.css");
        if (css == null) {
            css = RESOURCES.getString("SwaggerUI.css");
        }
        Div outer = HtmlBuilder.div(HtmlBuilder.style((Object)css), HtmlBuilder.script("text/javascript", RESOURCES.getString("SwaggerUI.js")), this.header(s))._class("swagger-ui");
        outer.child(HtmlBuilder.div()._class("tag-block tag-block-open").children(this.tagBlockContents(s, null)));
        if (s.swagger.hasTags()) {
            for (Tag t : s.swagger.getTags()) {
                Div tagBlock = HtmlBuilder.div()._class("tag-block tag-block-open").children(this.tagBlockSummary(t), this.tagBlockContents(s, t));
                outer.child(tagBlock);
            }
        }
        if (s.swagger.hasDefinitions()) {
            Div modelBlock = HtmlBuilder.div()._class("tag-block").children(this.modelsBlockSummary(), this.modelsBlockContents(s));
            outer.child(modelBlock);
        }
        return outer;
    }

    private Table header(Session s) {
        Table table = HtmlBuilder.table()._class("header");
        Info info = s.swagger.getInfo();
        if (info != null) {
            ExternalDocumentation ed;
            License l;
            Contact c;
            if (info.hasDescription()) {
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Description:"), HtmlBuilder.td(SwaggerUI.toBRL(info.getDescription()))));
            }
            if (info.hasVersion()) {
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Version:"), HtmlBuilder.td(info.getVersion())));
            }
            if ((c = info.getContact()) != null) {
                Table t2 = HtmlBuilder.table();
                if (c.hasName()) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("Name:"), HtmlBuilder.td(c.getName())));
                }
                if (c.hasUrl()) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("URL:"), HtmlBuilder.td(HtmlBuilder.a(c.getUrl(), c.getUrl()))));
                }
                if (c.hasEmail()) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("Email:"), HtmlBuilder.td(HtmlBuilder.a("mailto:" + c.getEmail(), c.getEmail()))));
                }
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Contact:"), HtmlBuilder.td(t2)));
            }
            if ((l = info.getLicense()) != null) {
                String child = l.hasUrl() ? HtmlBuilder.a(l.getUrl(), l.hasName() ? l.getName() : l.getUrl()) : l.getName();
                table.child(HtmlBuilder.tr(HtmlBuilder.th("License:"), HtmlBuilder.td(child)));
            }
            if ((ed = s.swagger.getExternalDocs()) != null) {
                String child = ed.hasUrl() ? HtmlBuilder.a(ed.getUrl(), ed.hasDescription() ? ed.getDescription() : ed.getUrl()) : ed.getDescription();
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Docs:"), HtmlBuilder.td(child)));
            }
            if (info.hasTermsOfService()) {
                String tos = info.getTermsOfService();
                String child = StringUtils.isUri((String)tos) ? HtmlBuilder.a(tos, tos) : tos;
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Terms of Service:"), HtmlBuilder.td(child)));
            }
        }
        return table;
    }

    private HtmlElement tagBlockSummary(Tag t) {
        ExternalDocumentation ed = t.getExternalDocs();
        return HtmlBuilder.div()._class("tag-block-summary").children(HtmlBuilder.span(t.getName())._class("name"), HtmlBuilder.span(SwaggerUI.toBRL(t.getDescription()))._class("description"), ed == null ? null : HtmlBuilder.span(HtmlBuilder.a(ed.getUrl(), ed.hasDescription() ? ed.getDescription() : ed.getUrl()))._class("extdocs")).onclick("toggleTagBlock(this)");
    }

    private Div tagBlockContents(Session s, Tag t) {
        Div tagBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        for (Map.Entry<String, OperationMap> e : s.swagger.getPaths().entrySet()) {
            String path = e.getKey();
            for (Map.Entry e2 : e.getValue().entrySet()) {
                String opName = (String)e2.getKey();
                Operation op = (Operation)e2.getValue();
                if ((t != null || !op.hasNoTags()) && (t == null || !op.hasTag(t.getName()))) continue;
                tagBlockContents.child(this.opBlock(s, path, opName, op));
            }
        }
        return tagBlockContents;
    }

    private Div opBlock(Session s, String path, String opName, Operation op) {
        String opClass;
        String string = opClass = op.isDeprecated() ? "deprecated" : opName.toLowerCase();
        if (!op.isDeprecated() && !STANDARD_METHODS.contains(opClass)) {
            opClass = "other";
        }
        return HtmlBuilder.div()._class("op-block op-block-closed " + opClass).children(this.opBlockSummary(path, opName, op), HtmlBuilder.div(this.tableContainer(s, op))._class("op-block-contents"));
    }

    private HtmlElement opBlockSummary(String path, String opName, Operation op) {
        return HtmlBuilder.div()._class("op-block-summary").children(HtmlBuilder.span(opName.toUpperCase())._class("method-button"), HtmlBuilder.span(path)._class("path"), op.hasSummary() ? HtmlBuilder.span(op.getSummary())._class("summary") : null).onclick("toggleOpBlock(this)");
    }

    private Div tableContainer(Session s, Operation op) {
        Div tableContainer = HtmlBuilder.div()._class("table-container");
        if (op.hasDescription()) {
            tableContainer.child(HtmlBuilder.div(SwaggerUI.toBRL(op.getDescription()))._class("op-block-description"));
        }
        if (op.hasParameters()) {
            tableContainer.child(HtmlBuilder.div(HtmlBuilder.h4("Parameters")._class("title"))._class("op-block-section-header"));
            Table parameters = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Name")._class("parameter-key"), HtmlBuilder.th("Description")._class("parameter-key")))._class("parameters");
            for (ParameterInfo parameterInfo : op.getParameters()) {
                String piName = "body".equals(parameterInfo.getIn()) ? "body" : parameterInfo.getName();
                boolean required = parameterInfo.getRequired() == null ? false : parameterInfo.getRequired();
                Td parameterKey = HtmlBuilder.td(HtmlBuilder.div(piName)._class("name" + (required ? " required" : "")), required ? HtmlBuilder.div("required")._class("requiredlabel") : null, HtmlBuilder.div(parameterInfo.getType())._class("type"), HtmlBuilder.div('(' + parameterInfo.getIn() + ')')._class("in"))._class("parameter-key");
                Td parameterValue = HtmlBuilder.td(HtmlBuilder.div(SwaggerUI.toBRL(parameterInfo.getDescription()))._class("description"), this.examples(s, parameterInfo))._class("parameter-value");
                parameters.child(HtmlBuilder.tr(parameterKey, parameterValue));
            }
            tableContainer.child(parameters);
        }
        if (op.hasResponses()) {
            tableContainer.child(HtmlBuilder.div(HtmlBuilder.h4("Responses")._class("title"))._class("op-block-section-header"));
            Table responses = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Code")._class("response-key"), HtmlBuilder.th("Description")._class("response-key")))._class("responses");
            tableContainer.child(responses);
            for (Map.Entry entry : op.getResponses().entrySet()) {
                ResponseInfo ri = (ResponseInfo)entry.getValue();
                Td code = HtmlBuilder.td(entry.getKey())._class("response-key");
                Td codeValue = HtmlBuilder.td(HtmlBuilder.div(SwaggerUI.toBRL(ri.getDescription()))._class("description"), this.examples(s, ri), this.headers(s, ri))._class("response-value");
                responses.child(HtmlBuilder.tr(code, codeValue));
            }
        }
        return tableContainer;
    }

    private Div headers(Session s, ResponseInfo ri) {
        if (!ri.hasHeaders()) {
            return null;
        }
        Table sectionTable = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Name"), HtmlBuilder.th("Description"), HtmlBuilder.th("Schema")))._class("section-table");
        Div headers = HtmlBuilder.div(HtmlBuilder.div("Headers:")._class("section-name"), sectionTable)._class("headers");
        for (Map.Entry<String, HeaderInfo> e : ri.getHeaders().entrySet()) {
            String name = e.getKey();
            HeaderInfo hi = e.getValue();
            sectionTable.child(HtmlBuilder.tr(HtmlBuilder.td(name)._class("name"), HtmlBuilder.td(SwaggerUI.toBRL(hi.getDescription()))._class("description"), HtmlBuilder.td(hi.asMap().keepAll(new String[]{"type", "format", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "enum", "multipleOf"}))));
        }
        return headers;
    }

    private Div examples(Session s, ParameterInfo pi) {
        boolean isBody = "body".equals(pi.getIn());
        OMap m = new OMap();
        try {
            if (isBody) {
                SchemaInfo si = pi.getSchema();
                if (si != null) {
                    m.put((Object)"model", (Object)si.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth));
                }
            } else {
                OMap om = pi.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth).asMap().keepAll(new String[]{"format", "pattern", "collectionFormat", "maximum", "minimum", "multipleOf", "maxLength", "minLength", "maxItems", "minItems", "allowEmptyValue", "exclusiveMaximum", "exclusiveMinimum", "uniqueItems", "items", "default", "enum"});
                m.put((Object)"model", (Object)(om.isEmpty() ? HtmlBuilder.i("none") : om));
            }
            Map<String, String> examples = pi.getExamples();
            if (examples != null) {
                for (Map.Entry<String, String> e : examples.entrySet()) {
                    m.put((Object)e.getKey(), (Object)e.getValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return this.examplesDiv(m);
    }

    private Div examples(Session s, ResponseInfo ri) {
        SchemaInfo si = ri.getSchema();
        OMap m = new OMap();
        try {
            Map<String, Object> examples;
            if (si != null) {
                si = si.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth);
                m.put((Object)"model", (Object)si);
            }
            if ((examples = ri.getExamples()) != null) {
                for (Map.Entry<String, Object> e : examples.entrySet()) {
                    m.put((Object)e.getKey(), e.getValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return this.examplesDiv(m);
    }

    private Div examplesDiv(OMap m) {
        if (m.isEmpty()) {
            return null;
        }
        Select select = null;
        if (m.size() > 1) {
            select = (Select)HtmlBuilder.select().onchange("selectExample(this)")._class("example-select");
        }
        Div div = HtmlBuilder.div(select)._class("examples");
        if (select != null) {
            select.child(HtmlBuilder.option("model", "model"));
        }
        div.child(HtmlBuilder.div(m.remove((Object)"model"))._class("model active").attr("data-name", "model"));
        for (Map.Entry e : m.entrySet()) {
            if (select != null) {
                select.child(HtmlBuilder.option(e.getKey(), e.getKey()));
            }
            div.child(HtmlBuilder.div(e.getValue().toString().replaceAll("\\n", "\n"))._class("example").attr("data-name", e.getKey()));
        }
        return div;
    }

    private HtmlElement modelsBlockSummary() {
        return HtmlBuilder.div()._class("tag-block-summary").children(HtmlBuilder.span("Models")._class("name")).onclick("toggleTagBlock(this)");
    }

    private Div modelsBlockContents(Session s) {
        Div modelBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        for (Map.Entry<String, OMap> e : s.swagger.getDefinitions().entrySet()) {
            modelBlockContents.child(this.modelBlock(e.getKey(), e.getValue()));
        }
        return modelBlockContents;
    }

    private Div modelBlock(String modelName, OMap model) {
        return HtmlBuilder.div()._class("op-block op-block-closed model").children(this.modelBlockSummary(modelName, model), HtmlBuilder.div(model)._class("op-block-contents"));
    }

    private HtmlElement modelBlockSummary(String modelName, OMap model) {
        return HtmlBuilder.div()._class("op-block-summary").children(HtmlBuilder.span(modelName)._class("method-button"), model.containsKey((Object)"description") ? HtmlBuilder.span(SwaggerUI.toBRL(model.remove((Object)"description").toString()))._class("summary") : null).onclick("toggleOpBlock(this)");
    }

    private static List<Object> toBRL(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(44) == -1) {
            return Collections.singletonList(s);
        }
        ArrayList<Object> l = new ArrayList<Object>();
        String[] sa = s.split("\n");
        for (int i = 0; i < sa.length; ++i) {
            if (i > 0) {
                l.add(HtmlBuilder.br());
            }
            l.add(sa[i]);
        }
        return l;
    }

    private static final class Session {
        final int resolveRefsMaxDepth;
        final Swagger swagger;

        Session(BeanSession bs, Swagger swagger) {
            this.swagger = swagger.copy();
            this.resolveRefsMaxDepth = (Integer)bs.getProperty(SwaggerUI.SWAGGERUI_resolveRefsMaxDepth, Integer.class, (Object)1);
        }
    }
}

