/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.html.AsideFloat;
import org.apache.juneau.html.BasicHtmlDocTemplate;
import org.apache.juneau.html.HtmlDocSerializerBuilder;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlSchemaDocSerializer;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.html.HtmlWidget;
import org.apache.juneau.serializer.SerializerSessionArgs;

@ConfigurableContext
public class HtmlDocSerializer
extends HtmlStrippedDocSerializer {
    static final String PREFIX = "HtmlDocSerializer";
    public static final String HTMLDOC_aside = "HtmlDocSerializer.aside.ls";
    public static final String HTMLDOC_asideFloat = "HtmlDocSerializer.asideFloat.s";
    public static final String HTMLDOC_footer = "HtmlDocSerializer.footer.ls";
    public static final String HTMLDOC_head = "HtmlDocSerializer.head.ls";
    public static final String HTMLDOC_header = "HtmlDocSerializer.header.ls";
    public static final String HTMLDOC_nav = "HtmlDocSerializer.nav.ls";
    public static final String HTMLDOC_navlinks = "HtmlDocSerializer.navlinks.ls";
    public static final String HTMLDOC_navlinks_add = "HtmlDocSerializer.navlinks.ls/add";
    public static final String HTMLDOC_noResultsMessage = "HtmlDocSerializer.noResultsMessage.s";
    public static final String HTMLDOC_nowrap = "HtmlDocSerializer.nowrap.b";
    public static final String HTMLDOC_script = "HtmlDocSerializer.script.ls";
    public static final String HTMLDOC_script_add = "HtmlDocSerializer.script.ls/add";
    public static final String HTMLDOC_style = "HtmlDocSerializer.style.ls";
    public static final String HTMLDOC_style_add = "HtmlDocSerializer.style.ls/add";
    public static final String HTMLDOC_stylesheet = "HtmlDocSerializer.stylesheet.ls";
    public static final String HTMLDOC_stylesheet_add = "HtmlDocSerializer.stylesheet.ls/add";
    public static final String HTMLDOC_template = "HtmlDocSerializer.template.c";
    public static final String HTMLDOC_widgets = "HtmlDocSerializer.widgets.lo";
    public static final HtmlDocSerializer DEFAULT = new HtmlDocSerializer(PropertyStore.DEFAULT);
    private final String[] style = this.getArrayProperty("HtmlDocSerializer.style.ls", String.class);
    private final String[] stylesheet = this.getArrayProperty("HtmlDocSerializer.stylesheet.ls", String.class);
    private final String[] script = this.getArrayProperty("HtmlDocSerializer.script.ls", String.class);
    private final String[] navlinks;
    private final String[] head = this.getArrayProperty("HtmlDocSerializer.head.ls", String.class);
    private final String[] header = this.getArrayProperty("HtmlDocSerializer.header.ls", String.class);
    private final String[] nav = this.getArrayProperty("HtmlDocSerializer.nav.ls", String.class);
    private final String[] aside = this.getArrayProperty("HtmlDocSerializer.aside.ls", String.class);
    private final String[] footer;
    private final AsideFloat asideFloat = this.getProperty("HtmlDocSerializer.asideFloat.s", AsideFloat.class, AsideFloat.RIGHT);
    private final String noResultsMessage;
    private final boolean nowrap;
    private final HtmlDocTemplate template;
    private final Map<String, HtmlWidget> widgets;
    private volatile HtmlSchemaDocSerializer schemaSerializer;

    public HtmlDocSerializer(PropertyStore ps) {
        this(ps, "text/html", null);
    }

    public HtmlDocSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.footer = this.getArrayProperty(HTMLDOC_footer, String.class);
        this.nowrap = this.getBooleanProperty(HTMLDOC_nowrap, false);
        this.navlinks = this.getArrayProperty(HTMLDOC_navlinks, String.class);
        this.noResultsMessage = this.getStringProperty(HTMLDOC_noResultsMessage, "<p>no results</p>");
        this.template = this.getInstanceProperty(HTMLDOC_template, HtmlDocTemplate.class, BasicHtmlDocTemplate.class);
        HashMap<String, HtmlWidget> widgets = new HashMap<String, HtmlWidget>();
        for (HtmlWidget w : this.getInstanceArrayProperty(HTMLDOC_widgets, HtmlWidget.class, new HtmlWidget[0])) {
            widgets.put(w.getName(), w);
        }
        this.widgets = Collections.unmodifiableMap(widgets);
    }

    @Override
    public HtmlDocSerializerBuilder builder() {
        return new HtmlDocSerializerBuilder(this.getPropertyStore());
    }

    public static HtmlDocSerializerBuilder create() {
        return new HtmlDocSerializerBuilder();
    }

    @Override
    public HtmlDocSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public HtmlDocSerializerSession createSession(SerializerSessionArgs args) {
        return new HtmlDocSerializerSession(this, args);
    }

    @Override
    public HtmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = this.builder().build(HtmlSchemaDocSerializer.class);
        }
        return this.schemaSerializer;
    }

    protected final String[] getAside() {
        return this.aside;
    }

    protected final AsideFloat getAsideFloat() {
        return this.asideFloat;
    }

    protected final String[] getFooter() {
        return this.footer;
    }

    protected final String[] getHead() {
        return this.head;
    }

    protected final String[] getHeader() {
        return this.header;
    }

    protected final String[] getNav() {
        return this.nav;
    }

    protected final String[] getNavlinks() {
        return this.navlinks;
    }

    protected final String getNoResultsMessage() {
        return this.noResultsMessage;
    }

    protected final boolean isNowrap() {
        return this.nowrap;
    }

    protected final String[] getScript() {
        return this.script;
    }

    protected final String[] getStyle() {
        return this.style;
    }

    protected final String[] getStylesheet() {
        return this.stylesheet;
    }

    protected final HtmlDocTemplate getTemplate() {
        return this.template;
    }

    protected final Map<String, HtmlWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("header", this.header).a("nav", this.nav).a("navlinks", this.navlinks).a("aside", this.aside).a("asideFloat", (Object)this.asideFloat).a("footer", this.footer).a("style", this.style).a("head", this.head).a("stylesheet", this.stylesheet).a("nowrap", this.nowrap).a("template", this.template).a("noResultsMessage", this.noResultsMessage).a("widgets", this.widgets.keySet()));
    }
}

