/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import org.apache.juneau.BasicAssertionError;
import org.apache.juneau.BasicIllegalArgumentException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;

public class ThrowableUtils {
    public static void assertNotNull(Object o, String msg, Object ... args) throws IllegalArgumentException {
        if (o == null) {
            throw new BasicIllegalArgumentException(msg, args);
        }
    }

    public static void assertFieldNotNull(Object fieldValue, String fieldName) throws IllegalArgumentException {
        if (fieldValue == null) {
            throw new IllegalArgumentException("Field '" + fieldName + "' cannot be null.");
        }
    }

    public static void assertFieldPositive(int fieldValue, String fieldName) throws IllegalArgumentException {
        if (fieldValue <= 0) {
            throw new IllegalArgumentException("Field '" + fieldName + "' must be a positive integer.");
        }
    }

    public static void illegalArg(String msg, Object ... args) throws IllegalArgumentException {
        throw new BasicIllegalArgumentException(msg, args);
    }

    public static void assertSameThread(long threadId, String msg, Object ... args) throws IllegalStateException {
        if (Thread.currentThread().getId() != threadId) {
            throw new BasicIllegalArgumentException(msg, args);
        }
    }

    public static void assertExceptionContainsMessage(Throwable t, String msg) throws AssertionError {
        for (Throwable t2 = t; t2 != null; t2 = t2.getCause()) {
            if (t2.getMessage() == null || !t2.getMessage().contains(msg)) continue;
            return;
        }
        t.printStackTrace();
        throw new BasicAssertionError(t, "Throwable did not contain the expected message.  Message=[{0}]", msg);
    }

    public static <T extends Throwable> T getCause(Class<T> c, Throwable t) {
        while (t != null) {
            if (!c.isInstance(t = t.getCause())) continue;
            return (T)t;
        }
        return null;
    }

    public static void throwException(String name, String message, Class<?> ... throwables) throws Throwable {
        if (name != null) {
            for (Class<?> t : throwables) {
                if (!t.getName().endsWith(name)) continue;
                ThrowableUtils.doThrow(t, message);
            }
        }
    }

    private static void doThrow(Class<?> t, String msg) throws Throwable {
        ConstructorInfo c = null;
        ClassInfo ci = ClassInfo.of(t);
        if (msg != null) {
            c = ci.getPublicConstructor(String.class);
            if (c != null) {
                throw (Throwable)c.invoke(msg);
            }
            c = ci.getPublicConstructor(Object.class);
            if (c != null) {
                throw (Throwable)c.invoke(msg);
            }
        }
        if ((c = ci.getPublicConstructor(new Class[0])) != null) {
            throw (Throwable)c.invoke(new Object[0]);
        }
    }
}

