/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.oapi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.oapi.OpenApiBeanPropertyMeta;
import org.apache.juneau.oapi.OpenApiClassMeta;
import org.apache.juneau.oapi.OpenApiCommon;
import org.apache.juneau.oapi.OpenApiMetaProvider;
import org.apache.juneau.oapi.OpenApiParserBuilder;
import org.apache.juneau.oapi.OpenApiParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.uon.UonParser;

@ConfigurableContext
public class OpenApiParser
extends UonParser
implements OpenApiMetaProvider,
OpenApiCommon {
    static final String PREFIX = "OpenApiParser";
    public static final OpenApiParser DEFAULT = new OpenApiParser(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, OpenApiClassMeta> openApiClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, OpenApiBeanPropertyMeta> openApiBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, OpenApiBeanPropertyMeta>();
    private final HttpPartFormat format = this.getProperty("OpenApi.format.s", HttpPartFormat.class, HttpPartFormat.NO_FORMAT);
    private final HttpPartCollectionFormat collectionFormat = this.getProperty("OpenApi.collectionformat.s", HttpPartCollectionFormat.class, HttpPartCollectionFormat.NO_COLLECTION_FORMAT);

    public OpenApiParser(PropertyStore ps) {
        this(ps, "text/openapi");
    }

    public OpenApiParser(PropertyStore ps, String ... consumes) {
        super(ps, consumes);
    }

    @Override
    public OpenApiParserBuilder builder() {
        return new OpenApiParserBuilder(this.getPropertyStore());
    }

    public static OpenApiParserBuilder create() {
        return new OpenApiParserBuilder();
    }

    @Override
    public OpenApiParserSession createSession() {
        return new OpenApiParserSession(this, ParserSessionArgs.DEFAULT);
    }

    @Override
    public OpenApiParserSession createSession(ParserSessionArgs args) {
        return new OpenApiParserSession(this, args);
    }

    @Override
    public OpenApiParserSession createPartSession(ParserSessionArgs args) {
        return new OpenApiParserSession(this, args);
    }

    @Override
    public OpenApiClassMeta getOpenApiClassMeta(ClassMeta<?> cm) {
        OpenApiClassMeta m = this.openApiClassMetas.get(cm);
        if (m == null) {
            m = new OpenApiClassMeta(cm, this);
            this.openApiClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public OpenApiBeanPropertyMeta getOpenApiBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return OpenApiBeanPropertyMeta.DEFAULT;
        }
        OpenApiBeanPropertyMeta m = this.openApiBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new OpenApiBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.openApiBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final HttpPartFormat getFormat() {
        return this.format;
    }

    protected final HttpPartCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap());
    }
}

