/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.ui.SwaggerUI;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.jsonschema.annotation.JsonSchemaConfig;
import org.apache.juneau.rest.RestContextStats;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.RestMethod;

@HtmlDocConfig(navlinks={"up: request:/..", "options: servlet:/?method=OPTIONS", "stats: servlet:/stats"})
@JsonSchemaConfig(addDescriptionsTo="bean,collection,array,map,enum", addExamplesTo="bean,collection,array,map", ignoreTypes="Swagger,org.apache.juneau.dto.html5.*", useBeanDefs="true")
@BeanConfig(swaps={SwaggerUI.class})
public interface BasicRestMethods {
    @RestMethod(name="OPTIONS", path="/*", summary="Swagger documentation", description={"Swagger documentation for this resource."})
    @HtmlDocConfig(rank=10, navlinks={"back: servlet:/", "json: servlet:/?method=OPTIONS&Accept=text/json&plainText=true"}, aside={"NONE"})
    public Swagger getOptions(RestRequest var1);

    @RestMethod(name="OPTIONS", path="/*", summary="Swagger documentation", description={"Swagger documentation for this resource."})
    @HtmlDocConfig(rank=10, navlinks={"back: servlet:/", "json: servlet:/?Accept=text/json&plainText=true"}, aside={"NONE"})
    public Swagger getOptions2(RestRequest var1);

    @RestMethod(name="*", path="/error", summary="Error occurred", description={"An error occurred during handling of the request."})
    public void error();

    @RestMethod(name="GET", path="/stats", summary="Timing statistics", description={"Timing statistics for method invocations on this resource."})
    @HtmlDocConfig(rank=10, navlinks={"back: servlet:/", "json: servlet:/stats?Accept=text/json&plainText=true"}, aside={"NONE"})
    public RestContextStats getStats(RestRequest var1);
}

