/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.swagger;

import jakarta.servlet.ServletException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.Value;
import org.apache.juneau.annotation.ExternalDocs;
import org.apache.juneau.annotation.ExternalDocsAnnotation;
import org.apache.juneau.annotation.Items;
import org.apache.juneau.annotation.ItemsAnnotation;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SchemaAnnotation;
import org.apache.juneau.annotation.SubItems;
import org.apache.juneau.annotation.SubItemsAnnotation;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.annotation.Contact;
import org.apache.juneau.http.annotation.ContactAnnotation;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.FormDataAnnotation;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.HeaderAnnotation;
import org.apache.juneau.http.annotation.License;
import org.apache.juneau.http.annotation.LicenseAnnotation;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.PathAnnotation;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.QueryAnnotation;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseAnnotation;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.annotation.Tag;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.annotation.OpSwagger;
import org.apache.juneau.rest.annotation.OpSwaggerAnnotation;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.annotation.SwaggerAnnotation;
import org.apache.juneau.rest.httppart.RestPartType;
import org.apache.juneau.rest.swagger.SwaggerException;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.svl.VarResolverSession;

public class BasicSwaggerProviderSession {
    private final RestContext context;
    private final Class<?> c;
    private final ClassInfo rci;
    private final FileFinder ff;
    private final Messages mb;
    private final VarResolverSession vr;
    private final JsonParser jp = JsonParser.create().ignoreUnknownBeanProperties().build();
    private final JsonSchemaGeneratorSession js;
    private final Locale locale;

    public BasicSwaggerProviderSession(RestContext context, Locale locale, FileFinder ff, Messages messages, VarResolverSession vr, JsonSchemaGeneratorSession js) {
        this.context = context;
        this.c = context.getResourceClass();
        this.rci = ClassInfo.of(this.c);
        this.ff = ff;
        this.mb = messages;
        this.vr = vr;
        this.js = js;
        this.locale = locale;
    }

    /*
     * WARNING - void declaration
     */
    public Swagger getSwagger() throws Exception {
        String s;
        InputStream is = this.ff.getStream(this.rci.getSimpleName() + ".json", this.locale).orElse(null);
        Predicate<String> ne = StringUtils::isNotEmpty;
        Predicate<Collection> nec = CollectionUtils::isNotEmpty;
        Predicate<Map> nem = CollectionUtils::isNotEmpty;
        JsonMap omSwagger = Json5.DEFAULT.read(is, JsonMap.class);
        if (omSwagger == null) {
            omSwagger = new JsonMap();
        }
        for (Rest rr : this.rci.getAnnotations(this.context, Rest.class)) {
            JsonMap sInfo = omSwagger.getMap("info", true);
            sInfo.appendIf(ne, "title", this.firstNonEmpty(sInfo.getString("title"), this.resolve(new String[][]{rr.title()}))).appendIf(ne, "description", this.firstNonEmpty(sInfo.getString("description"), this.resolve(new String[][]{rr.description()})));
            org.apache.juneau.rest.annotation.Swagger r = rr.swagger();
            omSwagger.append(this.parseMap(r.value(), "@Swagger(value) on class {0}", this.c));
            if (!SwaggerAnnotation.empty(r)) {
                JsonMap info = omSwagger.getMap("info", true);
                info.appendIf(ne, "title", this.resolve(new String[][]{r.title()})).appendIf(ne, "description", this.resolve(new String[][]{r.description()})).appendIf(ne, "version", this.resolve(r.version())).appendIf(ne, "termsOfService", this.resolve(new String[][]{r.termsOfService()})).appendIf(nem, "contact", this.merge(info.getMap("contact"), this.toMap(r.contact(), "@Swagger(contact) on class {0}", this.c))).appendIf(nem, "license", this.merge(info.getMap("license"), this.toMap(r.license(), "@Swagger(license) on class {0}", this.c)));
            }
            omSwagger.appendIf(nem, "externalDocs", this.merge(omSwagger.getMap("externalDocs"), this.toMap(r.externalDocs(), "@Swagger(externalDocs) on class {0}", this.c))).appendIf(nec, "tags", this.merge(omSwagger.getList("tags"), this.toList(r.tags(), "@Swagger(tags) on class {0}", this.c)));
        }
        omSwagger.appendIf(nem, "externalDocs", this.parseMap(this.mb.findFirstString("externalDocs"), "Messages/externalDocs on class {0}", this.c));
        JsonMap info = omSwagger.getMap("info", true);
        info.appendIf(ne, "title", this.resolve(this.mb.findFirstString("title"))).appendIf(ne, "description", this.resolve(this.mb.findFirstString("description"))).appendIf(ne, "version", this.resolve(this.mb.findFirstString("version"))).appendIf(ne, "termsOfService", this.resolve(this.mb.findFirstString("termsOfService"))).appendIf(nem, "contact", this.parseMap(this.mb.findFirstString("contact"), "Messages/contact on class {0}", this.c)).appendIf(nem, "license", this.parseMap(this.mb.findFirstString("license"), "Messages/license on class {0}", this.c));
        if (info.isEmpty()) {
            omSwagger.remove("info");
        }
        JsonList produces = omSwagger.getList("produces", true);
        JsonList consumes = omSwagger.getList("consumes", true);
        if (consumes.isEmpty()) {
            consumes.addAll(this.context.getConsumes());
        }
        if (produces.isEmpty()) {
            produces.addAll(this.context.getProduces());
        }
        LinkedHashMap<String, JsonMap> tagMap = CollectionUtils.map();
        if (omSwagger.containsKey("tags")) {
            for (JsonMap jsonMap : omSwagger.getList("tags").elements(JsonMap.class)) {
                String string = jsonMap.getString("name");
                if (string == null) {
                    throw new SwaggerException(null, "Tag definition found without name in swagger JSON.", new Object[0]);
                }
                tagMap.put(string, jsonMap);
            }
        }
        if ((s = this.mb.findFirstString("tags")) != null) {
            for (JsonMap jsonMap : this.parseListOrCdl(s, "Messages/tags on class {0}", this.c).elements(JsonMap.class)) {
                String name = jsonMap.getString("name");
                if (name == null) {
                    throw new SwaggerException(null, "Tag definition found without name in resource bundle on class {0}", new Object[]{this.c});
                }
                if (tagMap.containsKey(name)) {
                    ((JsonMap)tagMap.get(name)).putAll(jsonMap);
                    continue;
                }
                tagMap.put(name, jsonMap);
            }
        }
        JsonMap jsonMap = omSwagger.getMap("definitions", true);
        for (String defId : jsonMap.keySet()) {
            this.js.addBeanDef(defId, new JsonMap((Map<?, ?>)jsonMap.getMap(defId)));
        }
        for (RestOpContext sm : this.context.getRestOperations().getOpContexts()) {
            List<MediaType> mProduces;
            List<MediaType> mConsumes;
            JsonMap header;
            Object mpi2;
            BeanSession bs = sm.getBeanContext().getSession();
            Method m = sm.getJavaMethod();
            MethodInfo mi = MethodInfo.of(m);
            AnnotationList al = mi.getAnnotationList(RestOpAnnotation.REST_OP_GROUP);
            String mn = m.getName();
            JsonMap op = this.getOperation(omSwagger, sm.getPathPattern(), sm.getHttpMethod().toLowerCase());
            Value<OpSwagger> _ms = Value.empty();
            al.forEachValue(OpSwagger.class, "swagger", OpSwaggerAnnotation::notEmpty, x -> _ms.set((OpSwagger)x));
            OpSwagger ms = _ms.orElseGet(() -> OpSwaggerAnnotation.create().build());
            op.append(this.parseMap(ms.value(), "@OpSwagger(value) on class {0} method {1}", this.c, m));
            op.appendIf(ne, "operationId", this.firstNonEmpty(this.resolve(ms.operationId()), op.getString("operationId"), mn));
            Value<Object> _summary = Value.empty();
            al.forEachValue(String.class, "summary", StringUtils.NOT_EMPTY, x -> _summary.set(x));
            op.appendIf(ne, "summary", this.firstNonEmpty(this.resolve(new String[][]{ms.summary()}), this.resolve(this.mb.findFirstString(mn + ".summary")), op.getString("summary"), this.resolve((String)_summary.orElse(null))));
            Value<String[]> _description = Value.empty();
            al.forEachValue(String[].class, "description", x -> ((String[])x).length > 0, x -> _description.set((String[])x));
            op.appendIf(ne, "description", this.firstNonEmpty(this.resolve(new String[][]{ms.description()}), this.resolve(this.mb.findFirstString(mn + ".description")), op.getString("description"), this.resolve(new String[][]{_description.orElse(new String[0])})));
            op.appendIf(ne, "deprecated", this.firstNonEmpty(this.resolve(ms.deprecated()), m.getAnnotation(Deprecated.class) != null || m.getDeclaringClass().getAnnotation(Deprecated.class) != null ? "true" : null));
            op.appendIf(nec, "tags", this.merge(this.parseListOrCdl(this.mb.findFirstString(mn + ".tags"), "Messages/tags on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.tags(), "@OpSwagger(tags) on class {0} method {1}", this.c, m)));
            op.appendIf(nec, "schemes", this.merge(this.parseListOrCdl(this.mb.findFirstString(mn + ".schemes"), "Messages/schemes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.schemes(), "@OpSwagger(schemes) on class {0} method {1}", this.c, m)));
            op.appendIf(nec, "consumes", (Collection)this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(mn + ".consumes"), "Messages/consumes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.consumes(), "@OpSwagger(consumes) on class {0} method {1}", this.c, m)));
            op.appendIf(nec, "produces", (Collection)this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(mn + ".produces"), "Messages/produces on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.produces(), "@OpSwagger(produces) on class {0} method {1}", this.c, m)));
            op.appendIf(nec, "parameters", this.merge(this.parseList(this.mb.findFirstString(mn + ".parameters"), "Messages/parameters on class {0} method {1}", this.c, m), this.parseList(ms.parameters(), "@OpSwagger(parameters) on class {0} method {1}", this.c, m)));
            op.appendIf(nem, "responses", this.merge(this.parseMap(this.mb.findFirstString(mn + ".responses"), "Messages/responses on class {0} method {1}", this.c, m), this.parseMap(ms.responses(), "@OpSwagger(responses) on class {0} method {1}", this.c, m)));
            op.appendIf(nem, "externalDocs", this.merge(op.getMap("externalDocs"), this.parseMap(this.mb.findFirstString(mn + ".externalDocs"), "Messages/externalDocs on class {0} method {1}", this.c, m), this.toMap(ms.externalDocs(), "@OpSwagger(externalDocs) on class {0} method {1}", this.c, m)));
            if (op.containsKey("tags")) {
                for (String string : op.getList("tags").elements(String.class)) {
                    if (tagMap.containsKey(string)) continue;
                    tagMap.put(string, JsonMap.of(new Object[]{"name", string}));
                }
            }
            JsonMap paramMap = new JsonMap();
            if (op.containsKey("parameters")) {
                for (JsonMap param : op.getList("parameters").elements(JsonMap.class)) {
                    paramMap.put(param.getString("in") + "." + ("body".equals(param.getString("in")) ? "body" : param.getString("name")), (Object)param);
                }
            }
            for (Object mpi2 : mi.getParams()) {
                JsonMap param;
                String name;
                ClassInfo pt = ((ParamInfo)mpi2).getParameterType();
                Type type = pt.innerType();
                if (((ParamInfo)mpi2).hasAnnotation(Content.class) || pt.hasAnnotation(Content.class)) {
                    JsonMap param2 = paramMap.getMap(String.valueOf((Object)RestPartType.BODY) + ".body", true).append("in", (Object)RestPartType.BODY);
                    JsonMap schema = this.getSchema(param2.getMap("schema"), type, bs);
                    ((ParamInfo)mpi2).forEachAnnotation(Schema.class, x -> true, x -> this.merge(schema, (Schema)x));
                    ((ParamInfo)mpi2).forEachAnnotation(Content.class, x -> true, x -> this.merge(schema, x.schema()));
                    this.pushupSchemaFields(RestPartType.BODY, param2, schema);
                    param2.appendIf(nem, "schema", schema);
                    param2.putIfAbsent("required", true);
                    this.addBodyExamples(sm, param2, false, type, this.locale);
                    continue;
                }
                if (((ParamInfo)mpi2).hasAnnotation(Query.class) || pt.hasAnnotation(Query.class)) {
                    name = QueryAnnotation.findName((ParamInfo)mpi2).orElse(null);
                    param = paramMap.getMap(String.valueOf((Object)RestPartType.QUERY) + "." + name, true).append("name", name).append("in", (Object)RestPartType.QUERY);
                    ((ParamInfo)mpi2).forEachAnnotation(Schema.class, x -> true, x -> this.merge(param, (Schema)x));
                    ((ParamInfo)mpi2).forEachAnnotation(Query.class, x -> true, x -> this.merge(param, x.schema()));
                    this.pushupSchemaFields(RestPartType.QUERY, param, this.getSchema(param.getMap("schema"), type, bs));
                    this.addParamExample(sm, param, RestPartType.QUERY, type);
                    continue;
                }
                if (((ParamInfo)mpi2).hasAnnotation(FormData.class) || pt.hasAnnotation(FormData.class)) {
                    name = FormDataAnnotation.findName((ParamInfo)mpi2).orElse(null);
                    param = paramMap.getMap(String.valueOf((Object)RestPartType.FORM_DATA) + "." + name, true).append("name", name).append("in", (Object)RestPartType.FORM_DATA);
                    ((ParamInfo)mpi2).forEachAnnotation(Schema.class, x -> true, x -> this.merge(param, (Schema)x));
                    ((ParamInfo)mpi2).forEachAnnotation(FormData.class, x -> true, x -> this.merge(param, x.schema()));
                    this.pushupSchemaFields(RestPartType.FORM_DATA, param, this.getSchema(param.getMap("schema"), type, bs));
                    this.addParamExample(sm, param, RestPartType.FORM_DATA, type);
                    continue;
                }
                if (((ParamInfo)mpi2).hasAnnotation(Header.class) || pt.hasAnnotation(Header.class)) {
                    name = HeaderAnnotation.findName((ParamInfo)mpi2).orElse(null);
                    param = paramMap.getMap(String.valueOf((Object)RestPartType.HEADER) + "." + name, true).append("name", name).append("in", (Object)RestPartType.HEADER);
                    ((ParamInfo)mpi2).forEachAnnotation(Schema.class, x -> true, x -> this.merge(param, (Schema)x));
                    ((ParamInfo)mpi2).forEachAnnotation(Header.class, x -> true, x -> this.merge(param, x.schema()));
                    this.pushupSchemaFields(RestPartType.HEADER, param, this.getSchema(param.getMap("schema"), type, bs));
                    this.addParamExample(sm, param, RestPartType.HEADER, type);
                    continue;
                }
                if (!((ParamInfo)mpi2).hasAnnotation(Path.class) && !pt.hasAnnotation(Path.class)) continue;
                name = PathAnnotation.findName((ParamInfo)mpi2).orElse(null);
                param = paramMap.getMap(String.valueOf((Object)RestPartType.PATH) + "." + name, true).append("name", name).append("in", (Object)RestPartType.PATH);
                ((ParamInfo)mpi2).forEachAnnotation(Schema.class, x -> true, x -> this.merge(param, (Schema)x));
                ((ParamInfo)mpi2).forEachAnnotation(Path.class, x -> true, x -> this.merge(param, x.schema()));
                this.pushupSchemaFields(RestPartType.PATH, param, this.getSchema(param.getMap("schema"), type, bs));
                this.addParamExample(sm, param, RestPartType.PATH, type);
                param.putIfAbsent("required", true);
            }
            if (!paramMap.isEmpty()) {
                op.put("parameters", (Object)paramMap.values());
            }
            JsonMap jsonMap2 = op.getMap("responses", true);
            mpi2 = mi.getExceptionTypes().iterator();
            while (mpi2.hasNext()) {
                ClassInfo eci = (ClassInfo)mpi2.next();
                if (!eci.hasAnnotation(Response.class)) continue;
                List<Response> la = eci.getAnnotations(this.context, Response.class);
                List<StatusCode> la2 = eci.getAnnotations(this.context, StatusCode.class);
                Set<Integer> codes = BasicSwaggerProviderSession.getCodes(la2, 500);
                for (Response a : la) {
                    for (Integer n : codes) {
                        JsonMap jsonMap3 = jsonMap2.getMap(String.valueOf(n), true);
                        this.merge(jsonMap3, a);
                        JsonMap schema = this.getSchema(jsonMap3.getMap("schema"), m.getGenericReturnType(), bs);
                        eci.forEachAnnotation(Schema.class, x -> true, x -> this.merge(schema, (Schema)x));
                        this.pushupSchemaFields(RestPartType.RESPONSE, jsonMap3, schema);
                        jsonMap3.appendIf(nem, "schema", schema);
                    }
                }
                List<MethodInfo> methods = eci.getMethods();
                for (int i = methods.size() - 1; i >= 0; --i) {
                    void var34_61;
                    MethodInfo ecmi = methods.get(i);
                    Header header2 = ecmi.getAnnotation(Header.class);
                    if (header2 == null) {
                        Header header3 = ecmi.getReturnType().unwrap(Value.class, Optional.class).getAnnotation(Header.class);
                    }
                    if (var34_61 == null || this.isMulti((Header)var34_61)) continue;
                    String string = var34_61.name();
                    for (Integer code : codes) {
                        header = jsonMap2.getMap(String.valueOf(code), true).getMap("headers", true).getMap(string, true);
                        ecmi.forEachAnnotation(this.context, Schema.class, x -> true, x -> this.merge(header, (Schema)x));
                        ecmi.getReturnType().unwrap(Value.class, Optional.class).forEachAnnotation(Schema.class, x -> true, x -> this.merge(header, (Schema)x));
                        this.pushupSchemaFields(RestPartType.RESPONSE_HEADER, header, this.getSchema(header.getMap("schema"), ecmi.getReturnType().unwrap(Value.class, Optional.class).innerType(), bs));
                    }
                }
            }
            if (mi.hasAnnotation(Response.class) || mi.getReturnType().unwrap(Value.class, Optional.class).hasAnnotation(Response.class)) {
                ArrayList<Response> la = CollectionUtils.list(new Response[0]);
                mi.forEachAnnotation(this.context, Response.class, x -> true, x -> la.add((Response)x));
                ArrayList<StatusCode> la2 = CollectionUtils.list(new StatusCode[0]);
                mi.forEachAnnotation(this.context, StatusCode.class, x -> true, x -> la2.add((StatusCode)x));
                Set<Integer> codes = BasicSwaggerProviderSession.getCodes(la2, 200);
                for (Response a : la) {
                    for (Integer code : codes) {
                        JsonMap om = jsonMap2.getMap(String.valueOf(code), true);
                        this.merge(om, a);
                        JsonMap jsonMap4 = this.getSchema(om.getMap("schema"), m.getGenericReturnType(), bs);
                        mi.forEachAnnotation(this.context, Schema.class, x -> true, x -> this.merge(jsonMap4, (Schema)x));
                        this.pushupSchemaFields(RestPartType.RESPONSE, om, jsonMap4);
                        om.appendIf(nem, "schema", jsonMap4);
                        this.addBodyExamples(sm, om, true, m.getGenericReturnType(), this.locale);
                    }
                }
                if (mi.getReturnType().hasAnnotation(Response.class)) {
                    List<MethodInfo> methods = mi.getReturnType().getMethods();
                    for (int i = methods.size() - 1; i >= 0; --i) {
                        MethodInfo ecmi = methods.get(i);
                        if (!ecmi.hasAnnotation(Header.class)) continue;
                        Header a = ecmi.getAnnotation(Header.class);
                        String ha = a.name();
                        if (this.isMulti(a)) continue;
                        for (Integer n : codes) {
                            JsonMap header2 = jsonMap2.getMap(String.valueOf(n), true).getMap("headers", true).getMap(ha, true);
                            ecmi.forEachAnnotation(this.context, Schema.class, x -> true, x -> this.merge(header2, (Schema)x));
                            ecmi.getReturnType().unwrap(Value.class, Optional.class).forEachAnnotation(Schema.class, x -> true, x -> this.merge(header2, (Schema)x));
                            this.merge(header2, a.schema());
                            this.pushupSchemaFields(RestPartType.RESPONSE_HEADER, header2, this.getSchema(header2, ecmi.getReturnType().innerType(), bs));
                        }
                    }
                }
            } else if (m.getGenericReturnType() != Void.TYPE) {
                Iterator<Map.Entry<String, Object>> om = jsonMap2.getMap("200", true);
                ClassInfo pt2 = ClassInfo.of(m.getGenericReturnType());
                JsonMap schema = this.getSchema(((JsonMap)((Object)om)).getMap("schema"), m.getGenericReturnType(), bs);
                pt2.forEachAnnotation(Schema.class, x -> true, x -> this.merge(schema, (Schema)x));
                this.pushupSchemaFields(RestPartType.RESPONSE, (JsonMap)((Object)om), schema);
                ((JsonMap)((Object)om)).appendIf(nem, "schema", schema);
                this.addBodyExamples(sm, (JsonMap)((Object)om), true, m.getGenericReturnType(), this.locale);
            }
            for (ParamInfo mpi3 : mi.getParams()) {
                Set<Integer> codes;
                ArrayList<Annotation> la;
                ClassInfo pt = mpi3.getParameterType();
                if (pt.is(Value.class) && (mpi3.hasAnnotation(Header.class) || pt.hasAnnotation(Header.class))) {
                    la = CollectionUtils.list(new Header[0]);
                    mpi3.forEachAnnotation(Header.class, x -> true, x -> la.add((Annotation)x));
                    pt.forEachAnnotation(Header.class, x -> true, x -> la.add((Annotation)x));
                    ArrayList<StatusCode> la2 = CollectionUtils.list(new StatusCode[0]);
                    mpi3.forEachAnnotation(StatusCode.class, x -> true, x -> la2.add((StatusCode)x));
                    pt.forEachAnnotation(StatusCode.class, x -> true, x -> la2.add((StatusCode)x));
                    codes = BasicSwaggerProviderSession.getCodes(la2, 200);
                    String name = HeaderAnnotation.findName(mpi3).orElse(null);
                    Type type = Value.unwrap(mpi3.getParameterType().innerType());
                    for (Header header4 : la) {
                        if (this.isMulti(header4)) continue;
                        for (Integer code : codes) {
                            header = jsonMap2.getMap(String.valueOf(code), true).getMap("headers", true).getMap(name, true);
                            mpi3.forEachAnnotation(Schema.class, x -> true, x -> this.merge(header, (Schema)x));
                            this.merge(header, header4.schema());
                            this.pushupSchemaFields(RestPartType.RESPONSE_HEADER, header, this.getSchema(header, type, bs));
                        }
                    }
                    continue;
                }
                if (!mpi3.hasAnnotation(Response.class) && !pt.hasAnnotation(Response.class)) continue;
                la = CollectionUtils.list(new Response[0]);
                mpi3.forEachAnnotation(Response.class, x -> true, x -> la.add((Annotation)x));
                pt.forEachAnnotation(Response.class, x -> true, x -> la.add((Annotation)x));
                ArrayList<StatusCode> la2 = CollectionUtils.list(new StatusCode[0]);
                mpi3.forEachAnnotation(StatusCode.class, x -> true, x -> la2.add((StatusCode)x));
                pt.forEachAnnotation(StatusCode.class, x -> true, x -> la2.add((StatusCode)x));
                codes = BasicSwaggerProviderSession.getCodes(la2, 200);
                Type type = Value.unwrap(mpi3.getParameterType().innerType());
                for (Response response : la) {
                    for (Integer code : codes) {
                        JsonMap om = jsonMap2.getMap(String.valueOf(code), true);
                        this.merge(om, response);
                        JsonMap schema = this.getSchema(om.getMap("schema"), type, bs);
                        mpi3.forEachAnnotation(Schema.class, x -> true, x -> this.merge(schema, (Schema)x));
                        la.forEach(x -> this.merge(schema, x.schema()));
                        this.pushupSchemaFields(RestPartType.RESPONSE, om, schema);
                        om.appendIf(nem, "schema", schema);
                    }
                }
            }
            for (Map.Entry<String, Object> e : jsonMap2.entrySet()) {
                String key = e.getKey();
                JsonMap val = jsonMap2.getMap(key);
                if (!StringUtils.isDecimal(key)) continue;
                val.appendIfAbsentIf(ne, "description", RestUtils.getHttpResponseText(Integer.parseInt(key)));
            }
            if (jsonMap2.isEmpty()) {
                op.remove("responses");
            } else {
                op.put("responses", (Object)new TreeMap<String, Object>(jsonMap2));
            }
            if (!op.containsKey("consumes") && !(mConsumes = sm.getSupportedContentTypes()).equals(consumes)) {
                op.put("consumes", (Object)mConsumes);
            }
            if (op.containsKey("produces") || (mProduces = sm.getSupportedAcceptTypes()).equals(produces)) continue;
            op.put("produces", (Object)mProduces);
        }
        if (this.js.getBeanDefs() != null) {
            for (Map.Entry<String, JsonMap> e : this.js.getBeanDefs().entrySet()) {
                jsonMap.put(e.getKey(), (Object)this.fixSwaggerExtensions(e.getValue()));
            }
        }
        if (jsonMap.isEmpty()) {
            omSwagger.remove("definitions");
        }
        if (!tagMap.isEmpty()) {
            omSwagger.put("tags", (Object)tagMap.values());
        }
        if (consumes.isEmpty()) {
            omSwagger.remove("consumes");
        }
        if (produces.isEmpty()) {
            omSwagger.remove("produces");
        }
        try {
            String string = Json5Serializer.DEFAULT_READABLE.toString(omSwagger);
            return this.jp.parse(string, Swagger.class);
        }
        catch (Exception exception) {
            throw new ServletException("Error detected in swagger.", (Throwable)exception);
        }
    }

    private boolean isMulti(Header h) {
        return "*".equals(h.name()) || "*".equals(h.value());
    }

    private JsonMap resolve(JsonMap om) throws ParseException {
        JsonMap om2 = null;
        if (om.containsKey("_value")) {
            om = om.modifiable();
            om2 = this.parseMap(om.remove("_value"));
        } else {
            om2 = new JsonMap();
        }
        for (Map.Entry<String, Object> e : om.entrySet()) {
            Object val = e.getValue();
            if (val instanceof JsonMap) {
                val = this.resolve((JsonMap)val);
            } else if (val instanceof JsonList) {
                val = this.resolve((JsonList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            om2.put(e.getKey(), val);
        }
        return om2;
    }

    private JsonList resolve(JsonList om) throws ParseException {
        JsonList ol2 = new JsonList();
        for (Object val : om) {
            if (val instanceof JsonMap) {
                val = this.resolve((JsonMap)val);
            } else if (val instanceof JsonList) {
                val = this.resolve((JsonList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            ol2.add(val);
        }
        return ol2;
    }

    private String resolve(String[] ... s) {
        for (String[] ss : s) {
            if (ss.length == 0) continue;
            return this.resolve(BasicSwaggerProviderSession.joinnl(new String[][]{ss}));
        }
        return null;
    }

    private String resolve(String s) {
        if (s == null) {
            return null;
        }
        return this.vr.resolve(s.trim());
    }

    private JsonMap parseMap(String[] o, String location, Object ... args) throws ParseException {
        if (o.length == 0) {
            return JsonMap.EMPTY_MAP;
        }
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private JsonMap parseMap(String o, String location, Object ... args) throws ParseException {
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private JsonMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = BasicSwaggerProviderSession.joinnl(new String[][]{(String[])o});
        }
        if (o instanceof String) {
            Object s = o.toString();
            if (((String)s).isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase((String)(s = this.resolve((String)s)))) {
                return JsonMap.of(new Object[]{"ignore", true});
            }
            if (!StringUtils.isJsonObject(s, true)) {
                s = "{" + (String)s + "}";
            }
            return JsonMap.ofJson((CharSequence)s);
        }
        if (o instanceof JsonMap) {
            return (JsonMap)o;
        }
        throw new SwaggerException(null, "Unexpected data type ''{0}''.  Expected JsonMap or String.", new Object[]{ClassUtils.className(o)});
    }

    private JsonList parseList(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            Object s;
            if (o == null) {
                return null;
            }
            Object object = s = o instanceof String[] ? BasicSwaggerProviderSession.joinnl(new String[][]{(String[])o}) : o.toString();
            if (((String)s).isEmpty()) {
                return null;
            }
            if (!StringUtils.isJsonArray(s = this.resolve((String)s), true)) {
                s = "[" + (String)s + "]";
            }
            return JsonList.ofJson((CharSequence)s);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private JsonList parseListOrCdl(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? BasicSwaggerProviderSession.joinnl(new String[][]{(String[])o}) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            s = this.resolve(s);
            return JsonList.ofJsonOrCdl(s);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private JsonMap merge(JsonMap ... maps) {
        JsonMap m = maps[0];
        for (int i = 1; i < maps.length; ++i) {
            if (maps[i] == null) continue;
            if (m == null) {
                m = new JsonMap();
            }
            m.putAll(maps[i]);
        }
        return m;
    }

    private JsonList merge(JsonList ... lists) {
        JsonList l = lists[0];
        for (int i = 1; i < lists.length; ++i) {
            if (lists[i] == null) continue;
            if (l == null) {
                l = new JsonList();
            }
            l.addAll(lists[i]);
        }
        return l;
    }

    @SafeVarargs
    private final <T> T firstNonEmpty(T ... t) {
        for (T oo : t) {
            if (ObjectUtils.isEmpty(oo)) continue;
            return oo;
        }
        return null;
    }

    private JsonMap toMap(ExternalDocs a, String location, Object ... locationArgs) {
        if (ExternalDocsAnnotation.empty(a)) {
            return null;
        }
        Predicate<String> ne = StringUtils::isNotEmpty;
        JsonMap om = JsonMap.create().appendIf(ne, "description", this.resolve(BasicSwaggerProviderSession.joinnl(new String[][]{a.description()}))).appendIf(ne, "url", this.resolve(a.url()));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private JsonMap toMap(Contact a, String location, Object ... locationArgs) {
        if (ContactAnnotation.empty(a)) {
            return null;
        }
        Predicate<String> ne = StringUtils::isNotEmpty;
        JsonMap om = JsonMap.create().appendIf(ne, "name", this.resolve(a.name())).appendIf(ne, "url", this.resolve(a.url())).appendIf(ne, "email", this.resolve(a.email()));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private JsonMap toMap(License a, String location, Object ... locationArgs) {
        if (LicenseAnnotation.empty(a)) {
            return null;
        }
        Predicate<String> ne = StringUtils::isNotEmpty;
        JsonMap om = JsonMap.create().appendIf(ne, "name", this.resolve(a.name())).appendIf(ne, "url", this.resolve(a.url()));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private JsonMap toMap(Tag a, String location, Object ... locationArgs) {
        JsonMap om = JsonMap.create();
        Predicate<String> ne = StringUtils::isNotEmpty;
        Predicate<Map> nem = CollectionUtils::isNotEmpty;
        om.appendIf(ne, "name", this.resolve(a.name())).appendIf(ne, "description", this.resolve(BasicSwaggerProviderSession.joinnl(new String[][]{a.description()}))).appendIf(nem, "externalDocs", this.merge(om.getMap("externalDocs"), this.toMap(a.externalDocs(), location, locationArgs)));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private JsonList toList(Tag[] aa, String location, Object ... locationArgs) {
        if (aa.length == 0) {
            return null;
        }
        JsonList ol = new JsonList();
        for (Tag a : aa) {
            ol.add(this.toMap(a, location, locationArgs));
        }
        return BasicSwaggerProviderSession.nullIfEmpty(ol);
    }

    private JsonMap getSchema(JsonMap schema, Type type, BeanSession bs) throws Exception {
        if (type == Swagger.class) {
            return JsonMap.create();
        }
        schema = BasicSwaggerProviderSession.newMap(schema);
        ClassMeta cm = bs.getClassMeta(type, new Type[0]);
        if (schema.getBoolean("ignore", false).booleanValue()) {
            return null;
        }
        if (schema.containsKey("type") || schema.containsKey("$ref")) {
            return schema;
        }
        JsonMap om = this.fixSwaggerExtensions(schema.append(this.js.getSchema(cm)));
        return om;
    }

    private JsonMap fixSwaggerExtensions(JsonMap om) {
        Predicate<Object> nn = ObjectUtils::isNotNull;
        om.appendIf(nn, "discriminator", om.remove("x-discriminator")).appendIf(nn, "readOnly", om.remove("x-readOnly")).appendIf(nn, "xml", om.remove("x-xml")).appendIf(nn, "externalDocs", om.remove("x-externalDocs")).appendIf(nn, "example", om.remove("x-example"));
        return BasicSwaggerProviderSession.nullIfEmpty(om);
    }

    private void addBodyExamples(RestOpContext sm, JsonMap piri, boolean response, Type type, Locale locale) throws Exception {
        JsonMap schema;
        String sex = piri.getString("example");
        if (sex == null && (schema = this.resolveRef(piri.getMap("schema"))) != null) {
            sex = schema.getString("example", schema.getString("example"));
        }
        if (StringUtils.isEmpty(sex)) {
            return;
        }
        Object example = null;
        if (StringUtils.isJson(sex)) {
            example = this.jp.parse(sex, type, new Type[0]);
        } else {
            ClassMeta cm = this.js.getClassMeta(type, new Type[0]);
            if (cm.hasStringMutater()) {
                example = cm.getStringMutater().mutate(sex);
            }
        }
        String examplesKey = "examples";
        JsonMap examples = piri.getMap(examplesKey);
        if (examples == null) {
            examples = new JsonMap();
        }
        List<MediaType> mediaTypes = response ? sm.getSerializers().getSupportedMediaTypes() : sm.getParsers().getSupportedMediaTypes();
        for (MediaType mt : mediaTypes) {
            Serializer s2;
            if (mt == MediaType.HTML || (s2 = sm.getSerializers().getSerializer(mt)) == null) continue;
            try {
                String eVal = ((SerializerSession.Builder)s2.createSession().locale(locale).mediaType(mt).apply(WriterSerializerSession.Builder.class, x -> x.useWhitespace(true))).build().serializeToString(example);
                examples.put(s2.getPrimaryMediaType().toString(), (Object)eVal);
            }
            catch (Exception e) {
                System.err.println("Could not serialize to media type [" + String.valueOf(mt) + "]: " + e.getLocalizedMessage());
            }
        }
        if (!examples.isEmpty()) {
            piri.put(examplesKey, (Object)examples);
        }
    }

    private void addParamExample(RestOpContext sm, JsonMap piri, RestPartType in, Type type) throws Exception {
        Object s = piri.getString("example");
        if (StringUtils.isEmpty((String)s)) {
            return;
        }
        JsonMap examples = piri.getMap("examples");
        if (examples == null) {
            examples = new JsonMap();
        }
        String paramName = piri.getString("name");
        if (in == RestPartType.QUERY) {
            s = "?" + StringUtils.urlEncodeLax(paramName) + "=" + StringUtils.urlEncodeLax((String)s);
        } else if (in == RestPartType.FORM_DATA) {
            s = paramName + "=" + (String)s;
        } else if (in == RestPartType.HEADER) {
            s = paramName + ": " + (String)s;
        } else if (in == RestPartType.PATH) {
            s = sm.getPathPattern().replace("{" + paramName + "}", StringUtils.urlEncodeLax((String)s));
        }
        examples.put("example", s);
        if (!examples.isEmpty()) {
            piri.put("examples", (Object)examples);
        }
    }

    private JsonMap resolveRef(JsonMap m) {
        String ref;
        if (m == null) {
            return null;
        }
        if (m.containsKey("$ref") && this.js.getBeanDefs() != null && (ref = m.getString("$ref")).startsWith("#/definitions/")) {
            return this.js.getBeanDefs().get(ref.substring(14));
        }
        return m;
    }

    private JsonMap getOperation(JsonMap om, String path, String httpMethod) {
        if (!om.containsKey("paths")) {
            om.put("paths", (Object)new JsonMap());
        }
        if (!(om = om.getMap("paths")).containsKey(path)) {
            om.put(path, (Object)new JsonMap());
        }
        if (!(om = om.getMap(path)).containsKey(httpMethod)) {
            om.put(httpMethod, (Object)new JsonMap());
        }
        return om.getMap(httpMethod);
    }

    private static JsonMap newMap(JsonMap om) {
        if (om == null) {
            return new JsonMap();
        }
        return om.modifiable();
    }

    private JsonMap merge(JsonMap om, Schema a) {
        try {
            if (SchemaAnnotation.empty(a)) {
                return om;
            }
            om = BasicSwaggerProviderSession.newMap(om);
            Predicate<String> ne = StringUtils::isNotEmpty;
            Predicate<Collection> nec = CollectionUtils::isNotEmpty;
            Predicate<Map> nem = CollectionUtils::isNotEmpty;
            Predicate<Boolean> nf = ObjectUtils::isTrue;
            Predicate<Long> nm1 = ObjectUtils::isNotMinusOne;
            return om.appendIf(nem, "additionalProperties", this.toJsonMap(a.additionalProperties())).appendIf(ne, "allOf", BasicSwaggerProviderSession.joinnl(new String[][]{a.allOf()})).appendFirst(ne, "collectionFormat", a.collectionFormat(), a.cf()).appendIf(ne, "default", BasicSwaggerProviderSession.joinnl(a._default(), a.df())).appendIf(ne, "discriminator", a.discriminator()).appendIf(ne, "description", this.resolve(a.description(), a.d())).appendFirst(nec, "enum", this.toSet(a._enum()), this.toSet(a.e())).appendIf(nf, "exclusiveMaximum", a.exclusiveMaximum() || a.emax()).appendIf(nf, "exclusiveMinimum", a.exclusiveMinimum() || a.emin()).appendIf(nem, "externalDocs", this.merge(om.getMap("externalDocs"), a.externalDocs())).appendFirst(ne, "format", a.format(), a.f()).appendIf(ne, "ignore", a.ignore() ? "true" : null).appendIf(nem, "items", this.merge(om.getMap("items"), a.items())).appendFirst(ne, "maximum", a.maximum(), a.max()).appendFirst(nm1, "maxItems", a.maxItems(), a.maxi()).appendFirst(nm1, "maxLength", a.maxLength(), a.maxl()).appendFirst(nm1, "maxProperties", a.maxProperties(), a.maxp()).appendFirst(ne, "minimum", a.minimum(), a.min()).appendFirst(nm1, "minItems", a.minItems(), a.mini()).appendFirst(nm1, "minLength", a.minLength(), a.minl()).appendFirst(nm1, "minProperties", a.minProperties(), a.minp()).appendFirst(ne, "multipleOf", a.multipleOf(), a.mo()).appendFirst(ne, "pattern", a.pattern(), a.p()).appendIf(nem, "properties", this.toJsonMap(a.properties())).appendIf(nf, "readOnly", a.readOnly() || a.ro()).appendIf(nf, "required", a.required() || a.r()).appendIf(ne, "title", a.title()).appendFirst(ne, "type", a.type(), a.t()).appendIf(nf, "uniqueItems", a.uniqueItems() || a.ui()).appendIf(ne, "xml", BasicSwaggerProviderSession.joinnl(new String[][]{a.xml()})).appendIf(ne, "$ref", a.$ref());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private JsonMap merge(JsonMap om, ExternalDocs a) {
        if (ExternalDocsAnnotation.empty(a)) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        Predicate<String> ne = StringUtils::isNotEmpty;
        return om.appendIf(ne, "description", this.resolve(new String[][]{a.description()})).appendIf(ne, "url", a.url());
    }

    private JsonMap merge(JsonMap om, Items a) throws ParseException {
        if (ItemsAnnotation.empty(a)) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        Predicate<String> ne = StringUtils::isNotEmpty;
        Predicate<Collection> nec = CollectionUtils::isNotEmpty;
        Predicate<Map> nem = CollectionUtils::isNotEmpty;
        Predicate<Boolean> nf = ObjectUtils::isTrue;
        Predicate<Long> nm1 = ObjectUtils::isNotMinusOne;
        return om.appendFirst(ne, "collectionFormat", a.collectionFormat(), a.cf()).appendIf(ne, "default", BasicSwaggerProviderSession.joinnl(a._default(), a.df())).appendFirst(nec, "enum", this.toSet(a._enum()), this.toSet(a.e())).appendFirst(ne, "format", a.format(), a.f()).appendIf(nf, "exclusiveMaximum", a.exclusiveMaximum() || a.emax()).appendIf(nf, "exclusiveMinimum", a.exclusiveMinimum() || a.emin()).appendIf(nem, "items", this.merge(om.getMap("items"), a.items())).appendFirst(ne, "maximum", a.maximum(), a.max()).appendFirst(nm1, "maxItems", a.maxItems(), a.maxi()).appendFirst(nm1, "maxLength", a.maxLength(), a.maxl()).appendFirst(ne, "minimum", a.minimum(), a.min()).appendFirst(nm1, "minItems", a.minItems(), a.mini()).appendFirst(nm1, "minLength", a.minLength(), a.minl()).appendFirst(ne, "multipleOf", a.multipleOf(), a.mo()).appendFirst(ne, "pattern", a.pattern(), a.p()).appendIf(nf, "uniqueItems", a.uniqueItems() || a.ui()).appendFirst(ne, "type", a.type(), a.t()).appendIf(ne, "$ref", a.$ref());
    }

    private JsonMap merge(JsonMap om, SubItems a) throws ParseException {
        if (SubItemsAnnotation.empty(a)) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        Predicate<String> ne = StringUtils::isNotEmpty;
        Predicate<Collection> nec = CollectionUtils::isNotEmpty;
        Predicate<Map> nem = CollectionUtils::isNotEmpty;
        Predicate<Boolean> nf = ObjectUtils::isTrue;
        Predicate<Long> nm1 = ObjectUtils::isNotMinusOne;
        return om.appendFirst(ne, "collectionFormat", a.collectionFormat(), a.cf()).appendIf(ne, "default", BasicSwaggerProviderSession.joinnl(a._default(), a.df())).appendFirst(nec, "enum", this.toSet(a._enum()), this.toSet(a.e())).appendIf(nf, "exclusiveMaximum", a.exclusiveMaximum() || a.emax()).appendIf(nf, "exclusiveMinimum", a.exclusiveMinimum() || a.emin()).appendFirst(ne, "format", a.format(), a.f()).appendIf(nem, "items", this.toJsonMap(a.items())).appendFirst(ne, "maximum", a.maximum(), a.max()).appendFirst(nm1, "maxItems", a.maxItems(), a.maxi()).appendFirst(nm1, "maxLength", a.maxLength(), a.maxl()).appendFirst(ne, "minimum", a.minimum(), a.min()).appendFirst(nm1, "minItems", a.minItems(), a.mini()).appendFirst(nm1, "minLength", a.minLength(), a.minl()).appendFirst(ne, "multipleOf", a.multipleOf(), a.mo()).appendFirst(ne, "pattern", a.pattern(), a.p()).appendFirst(ne, "type", a.type(), a.t()).appendIf(nf, "uniqueItems", a.uniqueItems() || a.ui()).appendIf(ne, "$ref", a.$ref());
    }

    private JsonMap merge(JsonMap om, Response a) throws ParseException {
        if (ResponseAnnotation.empty(a)) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        Predicate<Map> nem = CollectionUtils::isNotEmpty;
        if (!SchemaAnnotation.empty(a.schema())) {
            this.merge(om, a.schema());
        }
        return om.appendIf(nem, "examples", this.parseMap(a.examples())).appendIf(nem, "headers", this.merge(om.getMap("headers"), a.headers())).appendIf(nem, "schema", this.merge(om.getMap("schema"), a.schema()));
    }

    private JsonMap merge(JsonMap om, Header[] a) {
        if (a.length == 0) {
            return om;
        }
        om = BasicSwaggerProviderSession.newMap(om);
        for (Header aa : a) {
            String name = StringUtils.firstNonEmpty(aa.name(), aa.value());
            if (StringUtils.isEmpty(name)) {
                throw new IllegalArgumentException("@Header used without name or value.");
            }
            this.merge(om.getMap(name, true), aa.schema());
        }
        return om;
    }

    private JsonMap pushupSchemaFields(RestPartType type, JsonMap param, JsonMap schema) {
        Predicate<Object> ne = ObjectUtils::isNotEmpty;
        if (schema != null && !schema.isEmpty()) {
            if (type == RestPartType.BODY || type == RestPartType.RESPONSE) {
                param.appendIf(ne, "description", schema.remove("description"));
            } else {
                param.appendIfAbsentIf(ne, "collectionFormat", schema.remove("collectionFormat")).appendIfAbsentIf(ne, "default", schema.remove("default")).appendIfAbsentIf(ne, "description", schema.remove("description")).appendIfAbsentIf(ne, "enum", schema.remove("enum")).appendIfAbsentIf(ne, "example", schema.remove("example")).appendIfAbsentIf(ne, "exclusiveMaximum", schema.remove("exclusiveMaximum")).appendIfAbsentIf(ne, "exclusiveMinimum", schema.remove("exclusiveMinimum")).appendIfAbsentIf(ne, "format", schema.remove("format")).appendIfAbsentIf(ne, "items", schema.remove("items")).appendIfAbsentIf(ne, "maximum", schema.remove("maximum")).appendIfAbsentIf(ne, "maxItems", schema.remove("maxItems")).appendIfAbsentIf(ne, "maxLength", schema.remove("maxLength")).appendIfAbsentIf(ne, "minimum", schema.remove("minimum")).appendIfAbsentIf(ne, "minItems", schema.remove("minItems")).appendIfAbsentIf(ne, "minLength", schema.remove("minLength")).appendIfAbsentIf(ne, "multipleOf", schema.remove("multipleOf")).appendIfAbsentIf(ne, "pattern", schema.remove("pattern")).appendIfAbsentIf(ne, "required", schema.remove("required")).appendIfAbsentIf(ne, "type", schema.remove("type")).appendIfAbsentIf(ne, "uniqueItems", schema.remove("uniqueItems"));
                if ("object".equals(param.getString("type")) && !schema.isEmpty()) {
                    param.put("schema", (Object)schema);
                }
            }
        }
        return param;
    }

    private JsonMap toJsonMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        Object s = BasicSwaggerProviderSession.joinnl(new String[][]{ss});
        if (((String)s).isEmpty()) {
            return null;
        }
        if (!StringUtils.isJsonObject(s, true)) {
            s = "{" + (String)s + "}";
        }
        s = this.resolve((String)s);
        return JsonMap.ofJson((CharSequence)s);
    }

    private Set<String> toSet(String[] ss) {
        if (ss.length == 0) {
            return null;
        }
        LinkedHashSet<String> set = CollectionUtils.set(new String[0]);
        for (String s : ss) {
            StringUtils.split(s, x -> set.add((String)x));
        }
        return set.isEmpty() ? null : set;
    }

    static String joinnl(String[] ... s) {
        for (Object[] objectArray : s) {
            if (objectArray.length == 0) continue;
            return StringUtils.joinnl(objectArray).trim();
        }
        return "";
    }

    private static Set<Integer> getCodes(List<StatusCode> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (StatusCode a : la) {
            for (int i : a.value()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static JsonMap nullIfEmpty(JsonMap m) {
        return m == null || m.isEmpty() ? null : m;
    }

    private static JsonList nullIfEmpty(JsonList l) {
        return l == null || l.isEmpty() ? null : l;
    }
}

