/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swaps;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.swap.StringSwap;

public abstract class InputStreamSwap
extends StringSwap<InputStream> {
    protected byte[] toBytes(InputStream is) throws IOException {
        return IOUtils.readBytes(is);
    }

    protected InputStream toStream(byte[] b, ClassMeta<?> hint) {
        Class c;
        Class clazz = c = hint == null ? InputStream.class : hint.getInnerClass();
        if (c == InputStream.class || c == ByteArrayInputStream.class) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    public static class SpacedHex
    extends InputStreamSwap {
        @Override
        public String swap(BeanSession session, InputStream is) throws Exception {
            return StringUtils.toSpacedHex(this.toBytes(is));
        }

        @Override
        public InputStream unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return this.toStream(StringUtils.fromSpacedHex(s), hint);
        }
    }

    public static class Hex
    extends InputStreamSwap {
        @Override
        public String swap(BeanSession session, InputStream is) throws Exception {
            return StringUtils.toHex(this.toBytes(is));
        }

        @Override
        public InputStream unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return this.toStream(StringUtils.fromHex(s), hint);
        }
    }

    public static class Base64
    extends InputStreamSwap {
        @Override
        public String swap(BeanSession session, InputStream is) throws Exception {
            return StringUtils.base64Encode(this.toBytes(is));
        }

        @Override
        public InputStream unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return this.toStream(StringUtils.base64Decode(s), hint);
        }
    }
}

