/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.parser.AbstractDataParser;

public class CustomDataParser2
extends AbstractDataParser<ByteBuffer> {
    private final ObjectMapper MAPPER = new ObjectMapper();
    private static final Set<String> sellerOrderListHeader = Sets.newHashSet((Object[])new String[]{"avatar", "avatar_id", "name", "wxAppId"});
    private static final Set<String> subOrderListHeader = Sets.newHashSet((Object[])new String[]{"subOrderList_id", "warehouseName"});
    private static final Set<String> prodListHeader = Sets.newHashSet((Object[])new String[]{"catalogId", "deliveryType", "desc", "prodList_id", "pic", "preSale", "price", "originalPrice", "priceType", "purchaseNum", "refundType", "sellType", "skuInfo", "state", "type", "style", "domestic", "nationType", "hideBorder", "exchangeCouponProduct", "hgProductType", "pspProduct"});

    public CustomDataParser2() {
        subOrderListHeader.addAll(prodListHeader);
        sellerOrderListHeader.addAll(subOrderListHeader);
    }

    protected Map<String, Object> parse(ByteBuffer byteBuffer) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        JsonNode jsonNode = this.MAPPER.readTree(byteBuffer.array());
        HashMap outputMap = Maps.newHashMap();
        this.traverseJsonNode("", "", jsonNode, outputMap);
        outputMap.put("partition_column", format.format(new Date()));
        return outputMap;
    }

    private void traverseJsonNode(String parentKey, String currentKey, JsonNode jsonNode, Map<String, Object> flatmap) {
        if (jsonNode.isObject()) {
            String pathPrefix;
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Iterator iter = objectNode.fields();
            String string = pathPrefix = parentKey.isEmpty() ? "" : currentKey + "_";
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.traverseJsonNode(pathPrefix + (String)entry.getKey(), (String)entry.getKey(), (JsonNode)entry.getValue(), flatmap);
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            if (arrayNode.size() == 0) {
                if (StringUtils.equalsIgnoreCase((CharSequence)currentKey, (CharSequence)"sellerOrderList")) {
                    this.fillEmptyArraySellerOrderList(flatmap);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)currentKey, (CharSequence)"subOrderList")) {
                    this.fillEmptyArraySubOrderList(flatmap);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)currentKey, (CharSequence)"prodList")) {
                    this.fillEmptyArrayprodList(flatmap);
                }
            } else {
                for (int i = 0; i < arrayNode.size(); ++i) {
                    this.traverseJsonNode(parentKey, currentKey, arrayNode.get(i), flatmap);
                }
            }
        } else if (jsonNode.isValueNode()) {
            ValueNode valueNode = (ValueNode)jsonNode;
            this.getJsonValueByType(parentKey, currentKey, flatmap, valueNode);
        }
    }

    private void getJsonValueByType(String parentKey, String currentKey, Map<String, Object> flatmap, ValueNode valueNode) {
        if (valueNode.isShort()) {
            this.addValueToFlatMap(flatmap, currentKey, parentKey, valueNode.shortValue());
        } else if (valueNode.isInt()) {
            this.addValueToFlatMap(flatmap, currentKey, parentKey, valueNode.intValue());
        } else if (valueNode.isLong()) {
            this.addValueToFlatMap(flatmap, currentKey, parentKey, valueNode.longValue());
        } else if (valueNode.isBigDecimal()) {
            this.addValueToFlatMap(flatmap, currentKey, parentKey, valueNode.decimalValue());
        } else if (valueNode.isFloat()) {
            this.addValueToFlatMap(flatmap, currentKey, parentKey, Float.valueOf(valueNode.floatValue()));
        } else if (valueNode.isDouble()) {
            this.addValueToFlatMap(flatmap, currentKey, parentKey, valueNode.doubleValue());
        } else if (valueNode.isBoolean()) {
            this.addValueToFlatMap(flatmap, currentKey, parentKey, valueNode.booleanValue());
        } else {
            this.addValueToFlatMap(flatmap, currentKey, parentKey, valueNode.asText());
        }
    }

    private void addValueToFlatMap(Map<String, Object> flatmap, String key, String parentKey, Object val) {
        this.addValueToFlatMap(flatmap, key, parentKey, val, 0);
    }

    private void addValueToFlatMap(Map<String, Object> flatmap, String key, String parentKey, Object val, int iteTime) {
        if (flatmap.containsKey(key)) {
            key = parentKey;
            this.addValueToFlatMap(flatmap, key, parentKey, val, iteTime);
        } else {
            flatmap.put(key, val);
        }
    }

    private void fillEmptyArraySellerOrderList(Map<String, Object> flatmap) {
        sellerOrderListHeader.forEach(key -> flatmap.put((String)key, null));
    }

    private void fillEmptyArraySubOrderList(Map<String, Object> flatmap) {
        subOrderListHeader.forEach(key -> flatmap.put((String)key, null));
    }

    private void fillEmptyArrayprodList(Map<String, Object> flatmap) {
        prodListHeader.forEach(key -> flatmap.put((String)key, null));
    }
}

