/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Stream;
import org.nuxeo.client.objects.Entity;

public class PaginableEntity<E>
extends Entity {
    protected List<E> entries;
    protected int resultsCount;
    protected int pageSize;
    protected int maxPageSize;
    protected int currentPageSize;
    protected int currentPageIndex;
    protected int numberOfPages;
    protected int totalSize;
    protected int pageIndex;
    protected int pageCount;
    @JsonProperty(value="isPaginable")
    protected Boolean isPaginable;
    @JsonProperty(value="isPreviousPageAvailable")
    protected Boolean isPreviousPageAvailable;
    @JsonProperty(value="isNextPageAvailable")
    protected Boolean isNextPageAvailable;
    @JsonProperty(value="isLastPageAvailable")
    protected Boolean isLastPageAvailable;
    @JsonProperty(value="isSortable")
    protected Boolean isSortable;
    @JsonProperty(value="hasError")
    protected Boolean hasError;
    protected String errorMessage;

    public PaginableEntity(String entityType) {
        super(entityType);
    }

    public List<E> getEntries() {
        return this.entries;
    }

    public Stream<E> streamEntries() {
        return this.entries.stream();
    }

    public E getEntry(int index) {
        return this.entries.get(index);
    }

    public int size() {
        return this.entries.size();
    }

    public int getResultsCount() {
        return this.resultsCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getCurrentPageSize() {
        return this.currentPageSize;
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public boolean isPaginable() {
        return PaginableEntity.isTrue(this.isPaginable);
    }

    public boolean isPreviousPageAvailable() {
        return PaginableEntity.isTrue(this.isPreviousPageAvailable);
    }

    public boolean isNextPageAvailable() {
        return PaginableEntity.isTrue(this.isNextPageAvailable);
    }

    public boolean isLastPageAvailable() {
        return PaginableEntity.isTrue(this.isLastPageAvailable);
    }

    public boolean isSortable() {
        return PaginableEntity.isTrue(this.isSortable);
    }

    public boolean hasError() {
        return PaginableEntity.isTrue(this.hasError);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static boolean isTrue(Boolean bool) {
        return bool != null && bool != false;
    }
}

