/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.DefaultDiscoAwareModule;
import org.apache.vysper.xmpp.modules.ServerRuntimeContextService;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.AdhocCommandIQHandler;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.AdhocCommandSupport;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.AdhocCommandsService;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.CommandInfo;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Feature;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Identity;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoElement;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Item;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ItemRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServerInfoRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServiceDiscoveryRequestException;
import org.apache.vysper.xmpp.protocol.HandlerDictionary;
import org.apache.vysper.xmpp.protocol.NamespaceHandlerDictionary;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdhocCommandsModule
extends DefaultDiscoAwareModule
implements ItemRequestListener,
ServerInfoRequestListener,
ServerRuntimeContextService,
AdhocCommandsService {
    public static final String ADHOC_COMMANDS = "adhoc_commands";
    private final Logger logger = LoggerFactory.getLogger(AdhocCommandsModule.class);
    protected ServerRuntimeContext serverRuntimeContext;
    protected AdhocCommandIQHandler iqHandler;
    protected final List<AdhocCommandSupport> adhocCommandSupporters = new ArrayList<AdhocCommandSupport>();

    @Override
    public void initialize(ServerRuntimeContext serverRuntimeContext) {
        super.initialize(serverRuntimeContext);
        this.serverRuntimeContext = serverRuntimeContext;
        serverRuntimeContext.registerServerRuntimeContextService(this);
    }

    @Override
    public String getName() {
        return "XEP-0050 Ad-hoc Commands";
    }

    @Override
    public String getVersion() {
        return "1.2";
    }

    @Override
    protected void addItemRequestListeners(List<ItemRequestListener> itemRequestListeners) {
        itemRequestListeners.add(this);
    }

    @Override
    protected void addServerInfoRequestListeners(List<ServerInfoRequestListener> serverInfoRequestListeners) {
        serverInfoRequestListeners.add(this);
    }

    @Override
    public List<Item> getItemsFor(InfoRequest request) throws ServiceDiscoveryRequestException {
        if (!"http://jabber.org/protocol/commands".equals(request.getNode())) {
            return null;
        }
        ArrayList<CommandInfo> allCommandInfos = new ArrayList<CommandInfo>();
        for (AdhocCommandSupport adhocCommandSupporter : this.adhocCommandSupporters) {
            Collection<CommandInfo> commandInfos = adhocCommandSupporter.getCommandInfosForInfoRequest(request, true);
            if (commandInfos == null) continue;
            allCommandInfos.addAll(commandInfos);
        }
        if (allCommandInfos.size() == 0) {
            return null;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (CommandInfo commandInfo : allCommandInfos) {
            String node;
            Entity jid = commandInfo.getJid();
            if (jid == null) {
                jid = this.serverRuntimeContext.getServerEnitity();
            }
            if ((node = commandInfo.getNode()) == null) {
                this.logger.warn("no node for command info, ignoring. command name = " + commandInfo.getName());
                continue;
            }
            String name = commandInfo.getName() == null ? commandInfo.getNode() : commandInfo.getName();
            items.add(new Item(jid, name, node));
        }
        return items;
    }

    @Override
    public List<InfoElement> getServerInfosFor(InfoRequest request) throws ServiceDiscoveryRequestException {
        if (this.adhocCommandSupporters.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)request.getNode())) {
            return Arrays.asList(new Feature("http://jabber.org/protocol/commands"));
        }
        ArrayList<CommandInfo> allCommandInfos = new ArrayList<CommandInfo>();
        for (AdhocCommandSupport adhocCommandSupporter : this.adhocCommandSupporters) {
            Collection<CommandInfo> commandInfos = adhocCommandSupporter.getCommandInfosForInfoRequest(request, false);
            if (commandInfos == null) continue;
            allCommandInfos.addAll(commandInfos);
        }
        if (allCommandInfos.size() == 0) {
            return null;
        }
        CommandInfo commandInfo = (CommandInfo)allCommandInfos.get(0);
        ArrayList<InfoElement> infoElements = new ArrayList<InfoElement>();
        infoElements.add(new Identity("automation", "command-node", commandInfo.getName()));
        infoElements.add(new Feature("http://jabber.org/protocol/commands"));
        infoElements.add(new Feature("jabber:x:data"));
        return infoElements;
    }

    @Override
    public String getServiceName() {
        return ADHOC_COMMANDS;
    }

    @Override
    public void registerCommandSupport(AdhocCommandSupport adhocCommandSupport) {
        this.adhocCommandSupporters.add(adhocCommandSupport);
    }

    @Override
    protected void addHandlerDictionaries(List<HandlerDictionary> dictionary) {
        this.iqHandler = new AdhocCommandIQHandler(Collections.unmodifiableCollection(this.adhocCommandSupporters));
        dictionary.add(new NamespaceHandlerDictionary("http://jabber.org/protocol/commands", this.iqHandler));
    }
}

