/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.ProjectPlatform;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.WeakListeners;

final class BootClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final String PLATFORM_ACTIVE = "platform.active";
    private final Project project;
    private final PropertyEvaluator evaluator;
    private final String platformType;
    private JavaPlatformManager platformManager;
    private String activePlatformName;
    private boolean isActivePlatformValid;
    private List<PathResourceImplementation> resourcesCache;
    private long eventId;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final ClassPath endorsedClassPath;

    BootClassPathImplementation(@NullAllowed Project project, @NonNull PropertyEvaluator evaluator, @NullAllowed ClassPath endorsedClassPath, @NullAllowed String platformType) {
        assert (evaluator != null);
        this.project = project;
        this.endorsedClassPath = endorsedClassPath;
        this.evaluator = evaluator;
        this.platformType = platformType;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange(this, evaluator));
        if (endorsedClassPath != null) {
            endorsedClassPath.addPropertyChangeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        JavaPlatform jp;
        long currentId;
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            if (this.resourcesCache != null) {
                return this.resourcesCache;
            }
            currentId = this.eventId;
        }
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        if (this.endorsedClassPath != null) {
            for (ClassPath.Entry entry : this.endorsedClassPath.entries()) {
                result.add(ClassPathSupport.createResource(entry.getURL()));
            }
        }
        if ((jp = this.findActivePlatform()) != null) {
            ClassPath cp = jp.getBootstrapLibraries();
            assert (cp != null) : jp;
            for (ClassPath.Entry entry : cp.entries()) {
                result.add(ClassPathSupport.createResource(entry.getURL()));
            }
        }
        BootClassPathImplementation bootClassPathImplementation2 = this;
        synchronized (bootClassPathImplementation2) {
            if (currentId == this.eventId) {
                if (this.resourcesCache == null) {
                    this.resourcesCache = Collections.unmodifiableList(result);
                }
                return this.resourcesCache;
            }
            return Collections.unmodifiableList(result);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.evaluator && evt.getPropertyName().equals(PLATFORM_ACTIVE)) {
            this.resetCache();
        } else if (evt.getSource() == this.platformManager && "installedPlatforms".equals(evt.getPropertyName()) && this.activePlatformName != null) {
            if (this.isActivePlatformValid) {
                if (CommonProjectUtils.getActivePlatform(this.activePlatformName, this.platformType) == null) {
                    this.resetCache();
                }
            } else if (CommonProjectUtils.getActivePlatform(this.activePlatformName, this.platformType) != null) {
                this.resetCache();
            }
        } else if (this.endorsedClassPath != null && evt.getSource() == this.endorsedClassPath) {
            this.resetCache();
        }
    }

    private JavaPlatform findActivePlatform() {
        if (this.platformManager == null) {
            this.platformManager = JavaPlatformManager.getDefault();
            this.platformManager.addPropertyChangeListener(WeakListeners.propertyChange(this, this.platformManager));
        }
        this.activePlatformName = this.evaluator.getProperty(PLATFORM_ACTIVE);
        JavaPlatform activePlatform = CommonProjectUtils.getActivePlatform(this.activePlatformName, this.platformType);
        if (activePlatform != null) {
            this.isActivePlatformValid = true;
        } else {
            activePlatform = this.createPerProjectPlatform();
            this.isActivePlatformValid = false;
        }
        return activePlatform;
    }

    @CheckForNull
    private JavaPlatform createPerProjectPlatform() {
        if (this.project == null) {
            return null;
        }
        return ProjectPlatform.forProject(this.project, this.evaluator, this.platformType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            this.resourcesCache = null;
            ++this.eventId;
        }
        this.support.firePropertyChange("resources", null, null);
    }
}

