/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.flow.ParameterProviderReference;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedFunnel;
import org.apache.nifi.flow.VersionedLabel;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;

public class VersionedComponentAdditions {
    private Set<VersionedProcessGroup> processGroups;
    private Set<VersionedRemoteProcessGroup> remoteProcessGroups;
    private Set<VersionedProcessor> processors;
    private Set<VersionedPort> inputPorts;
    private Set<VersionedPort> outputPorts;
    private Set<VersionedConnection> connections;
    private Set<VersionedLabel> labels;
    private Set<VersionedFunnel> funnels;
    private Set<VersionedControllerService> controllerServices;
    private Map<String, VersionedParameterContext> parameterContexts;
    private Map<String, ParameterProviderReference> parameterProviders;

    private VersionedComponentAdditions(Builder builder) {
        this.processGroups = builder.processGroups == null ? Collections.emptySet() : Collections.unmodifiableSet(builder.processGroups);
        this.remoteProcessGroups = builder.remoteProcessGroups == null ? Collections.emptySet() : Collections.unmodifiableSet(builder.remoteProcessGroups);
        this.processors = builder.processors == null ? Collections.emptySet() : Collections.unmodifiableSet(builder.processors);
        this.inputPorts = builder.inputPorts == null ? Collections.emptySet() : Collections.unmodifiableSet(builder.inputPorts);
        this.outputPorts = builder.outputPorts == null ? Collections.emptySet() : Collections.unmodifiableSet(builder.outputPorts);
        this.connections = builder.connections == null ? Collections.emptySet() : Collections.unmodifiableSet(builder.connections);
        this.labels = builder.labels == null ? Collections.emptySet() : Collections.unmodifiableSet(builder.labels);
        this.funnels = builder.funnels == null ? Collections.emptySet() : Collections.unmodifiableSet(builder.funnels);
        this.controllerServices = builder.controllerServices == null ? Collections.emptySet() : Collections.unmodifiableSet(builder.controllerServices);
        this.parameterContexts = builder.parameterContexts == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.parameterContexts);
        this.parameterProviders = builder.parameterProviders == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.parameterProviders);
    }

    public Set<VersionedProcessGroup> getProcessGroups() {
        return this.processGroups;
    }

    public Set<VersionedRemoteProcessGroup> getRemoteProcessGroups() {
        return this.remoteProcessGroups;
    }

    public Set<VersionedProcessor> getProcessors() {
        return this.processors;
    }

    public Set<VersionedPort> getInputPorts() {
        return this.inputPorts;
    }

    public Set<VersionedPort> getOutputPorts() {
        return this.outputPorts;
    }

    public Set<VersionedConnection> getConnections() {
        return this.connections;
    }

    public Set<VersionedLabel> getLabels() {
        return this.labels;
    }

    public Set<VersionedFunnel> getFunnels() {
        return this.funnels;
    }

    public Set<VersionedControllerService> getControllerServices() {
        return this.controllerServices;
    }

    public Map<String, VersionedParameterContext> getParameterContexts() {
        return this.parameterContexts;
    }

    public Map<String, ParameterProviderReference> getParameterProviders() {
        return this.parameterProviders;
    }

    public static class Builder {
        private Set<VersionedProcessGroup> processGroups;
        private Set<VersionedRemoteProcessGroup> remoteProcessGroups;
        private Set<VersionedProcessor> processors;
        private Set<VersionedPort> inputPorts;
        private Set<VersionedPort> outputPorts;
        private Set<VersionedConnection> connections;
        private Set<VersionedLabel> labels;
        private Set<VersionedFunnel> funnels;
        private Set<VersionedControllerService> controllerServices;
        private Map<String, VersionedParameterContext> parameterContexts;
        private Map<String, ParameterProviderReference> parameterProviders;

        public Builder setProcessGroups(Set<VersionedProcessGroup> processGroups) {
            this.processGroups = processGroups;
            return this;
        }

        public Builder setRemoteProcessGroups(Set<VersionedRemoteProcessGroup> remoteProcessGroups) {
            this.remoteProcessGroups = remoteProcessGroups;
            return this;
        }

        public Builder setProcessors(Set<VersionedProcessor> processors) {
            this.processors = processors;
            return this;
        }

        public Builder setInputPorts(Set<VersionedPort> inputPorts) {
            this.inputPorts = inputPorts;
            return this;
        }

        public Builder setOutputPorts(Set<VersionedPort> outputPorts) {
            this.outputPorts = outputPorts;
            return this;
        }

        public Builder setConnections(Set<VersionedConnection> connections) {
            this.connections = connections;
            return this;
        }

        public Builder setLabels(Set<VersionedLabel> labels) {
            this.labels = labels;
            return this;
        }

        public Builder setFunnels(Set<VersionedFunnel> funnels) {
            this.funnels = funnels;
            return this;
        }

        public Builder setControllerServices(Set<VersionedControllerService> controllerServices) {
            this.controllerServices = controllerServices;
            return this;
        }

        public Builder setParameterContexts(Map<String, VersionedParameterContext> parameterContexts) {
            this.parameterContexts = parameterContexts;
            return this;
        }

        public Builder setParameterProviders(Map<String, ParameterProviderReference> parameterProviders) {
            this.parameterProviders = parameterProviders;
            return this;
        }

        public VersionedComponentAdditions build() {
            return new VersionedComponentAdditions(this);
        }
    }
}

