/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.nifi.bootstrap.command.io.ResponseStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResponseStreamHandler
implements ResponseStreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(FileResponseStreamHandler.class);
    private final Path outputPath;

    public FileResponseStreamHandler(Path outputPath) {
        this.outputPath = Objects.requireNonNull(outputPath);
    }

    @Override
    public void onResponseStream(InputStream responseStream) {
        try (OutputStream outputStream = Files.newOutputStream(this.outputPath, new OpenOption[0]);){
            responseStream.transferTo(outputStream);
        }
        catch (IOException e) {
            logger.warn("Write response stream failed for [%s]".formatted(this.outputPath), (Throwable)e);
        }
    }
}

