/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authorization.AuthorizationDeniedException;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;

@FunctionalInterface
public interface AuthorizationManager<T> {
    default public void verify(Supplier<? extends @Nullable Authentication> authentication, T object) {
        AuthorizationResult result = this.authorize(authentication, object);
        if (result != null && !result.isGranted()) {
            throw new AuthorizationDeniedException("Access Denied", result);
        }
    }

    public @Nullable AuthorizationResult authorize(Supplier<? extends @Nullable Authentication> var1, T var2);
}

