/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionExecution;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.interceptor.MethodRollbackEvent;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class TransactionInterceptor
extends TransactionAspectSupport
implements MethodInterceptor,
ApplicationEventPublisherAware,
Serializable {
    private @Nullable ApplicationEventPublisher applicationEventPublisher;

    public TransactionInterceptor() {
    }

    public TransactionInterceptor(TransactionManager ptm, TransactionAttributeSource tas) {
        this.setTransactionManager(ptm);
        this.setTransactionAttributeSource(tas);
    }

    @Deprecated(since="5.2.5")
    public TransactionInterceptor(PlatformTransactionManager ptm, TransactionAttributeSource tas) {
        this.setTransactionManager(ptm);
        this.setTransactionAttributeSource(tas);
    }

    @Deprecated(since="5.2.5")
    public TransactionInterceptor(PlatformTransactionManager ptm, Properties attributes) {
        this.setTransactionManager(ptm);
        this.setTransactionAttributes(attributes);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public @Nullable Object invoke(final MethodInvocation invocation) throws Throwable {
        Class targetClass = invocation.getThis() != null ? AopUtils.getTargetClass((Object)invocation.getThis()) : null;
        return this.invokeWithinTransaction(invocation.getMethod(), targetClass, new TransactionAspectSupport.InvocationCallback(){
            final /* synthetic */ TransactionInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public @Nullable Object proceedWithInvocation() throws Throwable {
                return invocation.proceed();
            }

            @Override
            public void onRollback(Throwable failure, TransactionExecution execution) {
                block3: {
                    MethodRollbackEvent event = new MethodRollbackEvent(invocation, failure, execution);
                    this.this$0.logger.trace((Object)event, failure);
                    if (this.this$0.applicationEventPublisher != null) {
                        try {
                            this.this$0.applicationEventPublisher.publishEvent((ApplicationEvent)event);
                        }
                        catch (Throwable ex) {
                            if (!this.this$0.logger.isWarnEnabled()) break block3;
                            this.this$0.logger.warn((Object)("Failed to publish " + String.valueOf((Object)event)), ex);
                        }
                    }
                }
            }
        });
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getTransactionManagerBeanName());
        oos.writeObject(this.getTransactionManager());
        oos.writeObject(this.getTransactionAttributeSource());
        oos.writeObject(this.getBeanFactory());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.setTransactionManagerBeanName((String)ois.readObject());
        this.setTransactionManager((PlatformTransactionManager)ois.readObject());
        this.setTransactionAttributeSource((TransactionAttributeSource)ois.readObject());
        this.setBeanFactory((BeanFactory)ois.readObject());
    }
}

