/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.topic.LocalTopicStats;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalTopicStatsImpl
implements LocalTopicStats {
    private static final AtomicLongFieldUpdater<LocalTopicStatsImpl> TOTAL_PUBLISHES = AtomicLongFieldUpdater.newUpdater(LocalTopicStatsImpl.class, "totalPublishes");
    private static final AtomicLongFieldUpdater<LocalTopicStatsImpl> TOTAL_RECEIVED_MESSAGES = AtomicLongFieldUpdater.newUpdater(LocalTopicStatsImpl.class, "totalReceivedMessages");
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    private final long creationTime = Clock.currentTimeMillis();
    @Probe(name="totalPublishes")
    private volatile long totalPublishes;
    @Probe(name="totalReceivedMessages")
    private volatile long totalReceivedMessages;

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getPublishOperationCount() {
        return this.totalPublishes;
    }

    public void incrementPublishes() {
        TOTAL_PUBLISHES.incrementAndGet(this);
    }

    @Override
    public long getReceiveOperationCount() {
        return this.totalReceivedMessages;
    }

    public void incrementReceives() {
        TOTAL_RECEIVED_MESSAGES.incrementAndGet(this);
    }

    public String toString() {
        return "LocalTopicStatsImpl{creationTime=" + this.creationTime + ", totalPublishes=" + this.totalPublishes + ", totalReceivedMessages=" + this.totalReceivedMessages + "}";
    }
}

