/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.widget.accordion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.jquery.ui.JQueryUIBehavior;
import org.wicketstuff.jquery.ui.widget.accordion.IAccordionListener;
import org.wicketstuff.jquery.ui.widget.tabs.AjaxTab;

public abstract class AccordionBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "accordion";
    private final IAccordionListener listener;
    private JQueryAjaxBehavior onCreateAjaxBehavior = null;
    private JQueryAjaxBehavior onActivateAjaxBehavior = null;

    public AccordionBehavior(String selector, IAccordionListener listener) {
        this(selector, new Options(), listener);
    }

    public AccordionBehavior(String selector, Options options, IAccordionListener listener) {
        super(selector, METHOD, options);
        this.listener = (IAccordionListener)Args.notNull((Object)listener, (String)"listener");
    }

    protected abstract List<ITab> getTabs();

    protected List<ITab> getVisibleTabs() {
        ArrayList list = Generics.newArrayList();
        for (ITab tab : this.getTabs()) {
            if (!tab.isVisible()) continue;
            list.add(tab);
        }
        return Collections.unmodifiableList(list);
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isCreateEventEnabled()) {
            this.onCreateAjaxBehavior = this.newOnActivateAjaxBehavior(this);
            component.add(new Behavior[]{this.onCreateAjaxBehavior});
        }
        if (this.listener.isActivateEventEnabled()) {
            this.onActivateAjaxBehavior = this.newOnActivateAjaxBehavior(this);
            component.add(new Behavior[]{this.onActivateAjaxBehavior});
        }
    }

    public void activate(int index, IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)this.$(new Object[]{"'option'", "'active'", index}));
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onCreateAjaxBehavior != null) {
            this.setOption("create", this.onCreateAjaxBehavior.getCallbackFunction());
        }
        if (this.onActivateAjaxBehavior != null) {
            this.setOption("activate", this.onActivateAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ActivateEvent) {
            int index = ((ActivateEvent)event).getIndex();
            List<ITab> tabs = this.getVisibleTabs();
            if (-1 < index && index < tabs.size()) {
                ITab tab = tabs.get(index);
                if (tab instanceof AjaxTab) {
                    ((AjaxTab)tab).load(target);
                }
                this.listener.onActivate(target, index, tab);
            }
        }
    }

    protected JQueryAjaxBehavior newOnActivateAjaxBehavior(IJQueryAjaxAware source) {
        return new OnActivateAjaxBehavior(source);
    }

    protected static class ActivateEvent
    extends JQueryEvent {
        private final int index = RequestCycleUtils.getQueryParameterValue((String)"index").toInt(-1);

        public int getIndex() {
            return this.index;
        }
    }

    protected static class OnActivateAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnActivateAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"index", (String)"jQuery(event.target).accordion('option', 'active')")};
        }

        protected JQueryEvent newEvent() {
            return new ActivateEvent();
        }
    }
}

