/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.hexviewer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.debugger.hexviewer.HexChangeListener;
import org.apache.pdfbox.debugger.hexviewer.HexChangedEvent;
import org.apache.pdfbox.debugger.hexviewer.HexModelChangeListener;
import org.apache.pdfbox.debugger.hexviewer.HexModelChangedEvent;

class HexModel
implements HexChangeListener {
    private final List<Byte> data;
    private final List<HexModelChangeListener> modelChangeListeners;

    HexModel(byte[] bytes) {
        this.data = new ArrayList<Byte>(bytes.length);
        for (byte b : bytes) {
            this.data.add(b);
        }
        this.modelChangeListeners = new ArrayList<HexModelChangeListener>();
    }

    public byte getByte(int index) {
        return this.data.get(index);
    }

    public char[] getLineChars(int lineNumber) {
        int start = (lineNumber - 1) * 16;
        int length = Math.min(this.data.size() - start, 16);
        char[] chars = new char[length];
        for (int i = 0; i < chars.length; ++i) {
            int c = Character.toChars(this.data.get(start) & 0xFF)[0];
            if (!HexModel.isAsciiPrintable((char)c)) {
                c = 46;
            }
            chars[i] = c;
            ++start;
        }
        return chars;
    }

    public byte[] getBytesForLine(int lineNumber) {
        int index = (lineNumber - 1) * 16;
        int length = Math.min(this.data.size() - index, 16);
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.data.get(index);
            ++index;
        }
        return bytes;
    }

    public int size() {
        return this.data.size();
    }

    public int totalLine() {
        return this.size() % 16 != 0 ? this.size() / 16 + 1 : this.size() / 16;
    }

    public static int lineNumber(int index) {
        int elementNo = index + 1;
        return elementNo % 16 != 0 ? elementNo / 16 + 1 : elementNo / 16;
    }

    public static int elementIndexInLine(int index) {
        return index % 16;
    }

    private static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public void addHexModelChangeListener(HexModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void updateModel(int index, byte value) {
        if (!this.data.get(index).equals(value)) {
            this.data.set(index, value);
            this.fireModelChanged(index);
        }
    }

    @Override
    public void hexChanged(HexChangedEvent event) {
        int index = event.getByteIndex();
        if (index != -1 && this.getByte(index) != event.getNewValue()) {
            this.data.set(index, event.getNewValue());
        }
        this.fireModelChanged(index);
    }

    private void fireModelChanged(int index) {
        this.modelChangeListeners.forEach(listener -> listener.hexModelChanged(new HexModelChangedEvent(index, 2)));
    }
}

