/*   Copyright 2004 The Apache Software Foundation
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package scomp.common;

import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlOptions;

import java.util.ArrayList;

public final class BaseCase {
    public static XmlOptions createOptions() {
        XmlOptions op = new XmlOptions();
        op.setErrorListener(new ArrayList<>());
        return op;
    }

    public static String[] getErrorCodes(XmlOptions options) {
        return options.getErrorListener().stream().map(XmlError::getErrorCode).toArray(String[]::new);
    }
}
