/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.struts.httpmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class BaseHttpMap
implements Map {
    public int size() {
        return this.keySet().size();
    }

    public boolean isEmpty() {
        return this.keySet().size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Object get(Object key) {
        return this.getValue(key);
    }

    public Object put(Object key, Object value) {
        Object old = this.getValue(key);
        this.putValue(key, value);
        return old;
    }

    public Object remove(Object key) {
        Object old = this.getValue(key);
        this.removeValue(key);
        return old;
    }

    public void putAll(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.putValue(key, map.get(key));
        }
    }

    public void clear() {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            this.removeValue(i.next());
        }
    }

    public Set keySet() {
        HashSet keySet = new HashSet();
        Enumeration names = this.getNames();
        while (names.hasMoreElements()) {
            keySet.add(names.nextElement());
        }
        return keySet;
    }

    public Collection values() {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration names = this.getNames();
        while (names.hasMoreElements()) {
            list.add(this.getValue(names.nextElement()));
        }
        return list;
    }

    public Set entrySet() {
        return new HashSet();
    }

    protected abstract Enumeration getNames();

    protected abstract Object getValue(Object var1);

    protected abstract void putValue(Object var1, Object var2);

    protected abstract void removeValue(Object var1);
}

