/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalDouble;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.node.NumericNode;

public abstract class NumericIntNode
extends NumericNode {
    private static final long serialVersionUID = 3L;

    @Override
    public final JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public final boolean isIntegralNumber() {
        return true;
    }

    @Override
    public final boolean isNaN() {
        return false;
    }

    @Override
    public final boolean canConvertToShort() {
        return this.inShortRange();
    }

    @Override
    public final boolean canConvertToInt() {
        return this.inIntRange();
    }

    @Override
    public final boolean canConvertToLong() {
        return this.inLongRange();
    }

    @Override
    public abstract BigInteger bigIntegerValue();

    @Override
    public BigInteger bigIntegerValue(BigInteger defaultValue) {
        return this.bigIntegerValue();
    }

    @Override
    public Optional<BigInteger> bigIntegerValueOpt() {
        return Optional.of(this.bigIntegerValue());
    }

    @Override
    public BigInteger asBigInteger() {
        return this.bigIntegerValue();
    }

    @Override
    public BigInteger asBigInteger(BigInteger defaultValue) {
        return this.bigIntegerValue();
    }

    @Override
    public Optional<BigInteger> asBigIntegerOpt() {
        return this.bigIntegerValueOpt();
    }

    @Override
    public float floatValue() {
        return this._asFloatValueUnchecked();
    }

    @Override
    public float floatValue(float defaultValue) {
        return this._asFloatValueUnchecked();
    }

    @Override
    public Optional<Float> floatValueOpt() {
        return Optional.of(Float.valueOf(this._asFloatValueUnchecked()));
    }

    @Override
    public float asFloat() {
        return this._asFloatValueUnchecked();
    }

    @Override
    public float asFloat(float defaultValue) {
        return this._asFloatValueUnchecked();
    }

    @Override
    public Optional<Float> asFloatOpt() {
        return Optional.of(Float.valueOf(this._asFloatValueUnchecked()));
    }

    @Override
    public double doubleValue() {
        return this._asDoubleValueUnchecked();
    }

    @Override
    public double doubleValue(double defaultValue) {
        return this._asDoubleValueUnchecked();
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        return OptionalDouble.of(this._asDoubleValueUnchecked());
    }

    @Override
    public double asDouble() {
        return this._asDoubleValueUnchecked();
    }

    @Override
    public double asDouble(double defaultValue) {
        return this._asDoubleValueUnchecked();
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        return OptionalDouble.of(this._asDoubleValueUnchecked());
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return this.decimalValue();
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(this.decimalValue());
    }

    @Override
    public BigDecimal asDecimal() {
        return this.decimalValue();
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        return this.decimalValue();
    }

    @Override
    public Optional<BigDecimal> asDecimalOpt() {
        return this.decimalValueOpt();
    }

    @Override
    public boolean hasFractionalPart() {
        return false;
    }

    protected abstract float _asFloatValueUnchecked();

    protected abstract double _asDoubleValueUnchecked();
}

