/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.model.Queue;

abstract class OverflowPolicyMaximumQueueDepthChangeListener
extends AbstractConfigurationChangeListener {
    private final OverflowPolicy _overflowPolicy;
    private boolean _maximumQueueDepthChangeDetected;

    OverflowPolicyMaximumQueueDepthChangeListener(OverflowPolicy overflowPolicy) {
        this._overflowPolicy = overflowPolicy;
    }

    @Override
    public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
        super.attributeSet(object, attributeName, oldAttributeValue, newAttributeValue);
        if ("maximumQueueDepthBytes".equals(attributeName) || "maximumQueueDepthMessages".equals(attributeName)) {
            this._maximumQueueDepthChangeDetected = true;
        }
    }

    @Override
    public void bulkChangeEnd(ConfiguredObject<?> object) {
        super.bulkChangeEnd(object);
        if (object instanceof Queue) {
            Queue queue = (Queue)object;
            if (queue.getOverflowPolicy() == this._overflowPolicy) {
                if (this._maximumQueueDepthChangeDetected) {
                    this._maximumQueueDepthChangeDetected = false;
                    this.onMaximumQueueDepthChange(queue);
                }
            } else {
                queue.removeChangeListener(this);
            }
        }
    }

    abstract void onMaximumQueueDepthChange(Queue<?> var1);
}

