/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseException;
import java.nio.ByteBuffer;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.FieldTableFactory;
import org.apache.qpid.server.store.berkeleydb.tuple.ByteBufferBinding;

public class FieldTableEncoding {
    private FieldTableEncoding() {
    }

    public static FieldTable readFieldTable(TupleInput tupleInput) throws DatabaseException {
        long length = tupleInput.readLong();
        if (length <= 0L) {
            return null;
        }
        ByteBuffer buf = ByteBufferBinding.getInstance().readByteBuffer(tupleInput, (int)length);
        return FieldTableFactory.createFieldTable((QpidByteBuffer)QpidByteBuffer.wrap((ByteBuffer)buf));
    }

    public static void writeFieldTable(FieldTable fieldTable, TupleOutput tupleOutput) {
        if (fieldTable == null) {
            tupleOutput.writeLong(0L);
        } else {
            tupleOutput.writeLong(fieldTable.getEncodedSize());
            tupleOutput.writeFast(fieldTable.getDataAsBytes());
        }
    }
}

