/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v1;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.config.v1.RocksDBConfigManager;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.rocksdb.CompressionType;

public class RocksDBSubscriptionGroupManager
extends SubscriptionGroupManager {
    protected transient RocksDBConfigManager rocksDBConfigManager;
    private static final String VERSION_COLUMN_FAMILY = "subscriptionGroupVersion";
    private static final String GROUP_COLUMN_FAMILY = "subscriptionGroup";
    private static final String FORBIDDEN_COLUMN_FAMILY_NAME = "forbidden";
    private final boolean useSingleRocksDBForAllConfigs;
    private final String storePathRootDir;

    public RocksDBSubscriptionGroupManager(BrokerController brokerController, boolean useSingleRocksDB, String storePathRootDir) {
        super(brokerController, false);
        this.useSingleRocksDBForAllConfigs = useSingleRocksDB;
        this.storePathRootDir = StringUtils.isBlank((CharSequence)storePathRootDir) ? brokerController.getMessageStoreConfig().getStorePathRootDir() : storePathRootDir;
        long flushInterval = brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs();
        CompressionType compressionType = CompressionType.getCompressionType((String)brokerController.getMessageStoreConfig().getRocksdbCompressionType());
        String rocksDBPath = this.rocksdbConfigFilePath(storePathRootDir, useSingleRocksDB);
        this.rocksDBConfigManager = useSingleRocksDB ? new RocksDBConfigManager(rocksDBPath, flushInterval, compressionType, GROUP_COLUMN_FAMILY, VERSION_COLUMN_FAMILY) : new RocksDBConfigManager(rocksDBPath, flushInterval, compressionType);
    }

    public RocksDBSubscriptionGroupManager(BrokerController brokerController, boolean useSingleRocksDBForAllConfigs) {
        this(brokerController, useSingleRocksDBForAllConfigs, null);
    }

    public RocksDBSubscriptionGroupManager(BrokerController brokerController) {
        this(brokerController, brokerController.getBrokerConfig().isUseSingleRocksDBForAllConfigs(), null);
    }

    public boolean load() {
        if (!this.rocksDBConfigManager.init()) {
            return false;
        }
        if (!this.loadDataVersion() || !this.loadSubscriptionGroupAndForbidden()) {
            return false;
        }
        if (this.useSingleRocksDBForAllConfigs) {
            this.migrateFromSeparateRocksDBs();
        }
        this.init();
        return true;
    }

    @Override
    public boolean loadDataVersion() {
        return this.rocksDBConfigManager.loadDataVersion();
    }

    public boolean loadSubscriptionGroupAndForbidden() {
        return this.rocksDBConfigManager.loadData(this::decodeSubscriptionGroup) && this.loadForbidden(this::decodeForbidden) && this.merge();
    }

    public boolean loadForbidden(BiConsumer<byte[], byte[]> biConsumer) {
        try {
            this.rocksDBConfigManager.configRocksDBStorage.iterate(FORBIDDEN_COLUMN_FAMILY_NAME, biConsumer);
            return true;
        }
        catch (Exception e) {
            log.error("loadForbidden exception", (Throwable)e);
            return false;
        }
    }

    private boolean merge() {
        if (!UtilAll.isPathExists((String)this.configFilePath()) && !UtilAll.isPathExists((String)(this.configFilePath() + ".bak"))) {
            log.info("subGroup json file does not exist, so skip merge");
            return true;
        }
        if (!super.loadDataVersion()) {
            log.error("load json subGroup dataVersion error, startup will exit");
            return false;
        }
        DataVersion dataVersion = super.getDataVersion();
        DataVersion kvDataVersion = this.getDataVersion();
        if (dataVersion.getCounter().get() > kvDataVersion.getCounter().get()) {
            if (!super.load()) {
                log.error("load group and forbidden info from json file error, startup will exit");
                return false;
            }
            ConcurrentMap<String, SubscriptionGroupConfig> groupTable = this.getSubscriptionGroupTable();
            for (Map.Entry entry : groupTable.entrySet()) {
                this.putSubscriptionGroupConfig((SubscriptionGroupConfig)entry.getValue());
                log.info("import subscription config to rocksdb, group={}", entry.getValue());
            }
            ConcurrentMap<String, ConcurrentMap<String, Integer>> forbiddenTable = this.getForbiddenTable();
            for (Map.Entry entry : forbiddenTable.entrySet()) {
                try {
                    this.rocksDBConfigManager.put(FORBIDDEN_COLUMN_FAMILY_NAME, (String)entry.getKey(), JSON.toJSONString(entry.getValue()));
                    log.info("import forbidden config to rocksdb, group={}", entry.getValue());
                }
                catch (Exception e) {
                    log.error("import forbidden config to rocksdb failed, group={}", entry.getValue());
                    return false;
                }
            }
            this.getDataVersion().assignNewOne(dataVersion);
            this.updateDataVersion();
        } else {
            log.info("dataVersion is not greater than kvDataVersion, no need to merge group metaData, dataVersion={}, kvDataVersion={}", (Object)dataVersion, (Object)kvDataVersion);
        }
        log.info("finish merge subscription config from json file and merge to rocksdb");
        this.persist();
        return true;
    }

    public boolean stop() {
        return this.rocksDBConfigManager.stop();
    }

    @Override
    public SubscriptionGroupConfig putSubscriptionGroupConfig(SubscriptionGroupConfig subscriptionGroupConfig) {
        String groupName = subscriptionGroupConfig.getGroupName();
        SubscriptionGroupConfig oldConfig = this.subscriptionGroupTable.put(groupName, subscriptionGroupConfig);
        try {
            byte[] keyBytes = groupName.getBytes(RocksDBConfigManager.CHARSET);
            byte[] valueBytes = JSON.toJSONBytes((Object)subscriptionGroupConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
            this.rocksDBConfigManager.put(keyBytes, valueBytes);
        }
        catch (Exception e) {
            log.error("kv put sub Failed, {}", (Object)subscriptionGroupConfig.toString());
        }
        return oldConfig;
    }

    @Override
    protected SubscriptionGroupConfig putSubscriptionGroupConfigIfAbsent(SubscriptionGroupConfig subscriptionGroupConfig) {
        String groupName = subscriptionGroupConfig.getGroupName();
        SubscriptionGroupConfig oldConfig = this.subscriptionGroupTable.putIfAbsent(groupName, subscriptionGroupConfig);
        if (oldConfig == null) {
            try {
                byte[] keyBytes = groupName.getBytes(RocksDBConfigManager.CHARSET);
                byte[] valueBytes = JSON.toJSONBytes((Object)subscriptionGroupConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
                this.rocksDBConfigManager.put(keyBytes, valueBytes);
            }
            catch (Exception e) {
                log.error("kv put sub Failed, {}", (Object)subscriptionGroupConfig.toString());
            }
        }
        return oldConfig;
    }

    @Override
    protected SubscriptionGroupConfig removeSubscriptionGroupConfig(String groupName) {
        SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)this.subscriptionGroupTable.remove(groupName);
        try {
            this.rocksDBConfigManager.delete(groupName.getBytes(RocksDBConfigManager.CHARSET));
        }
        catch (Exception e) {
            log.error("kv delete sub Failed, {}", (Object)subscriptionGroupConfig.toString());
        }
        return subscriptionGroupConfig;
    }

    protected void decodeSubscriptionGroup(byte[] key, byte[] body) {
        String groupName = new String(key, RocksDBConfigManager.CHARSET);
        SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)JSON.parseObject((byte[])body, SubscriptionGroupConfig.class, (Feature[])new Feature[0]);
        this.subscriptionGroupTable.put(groupName, subscriptionGroupConfig);
        log.info("load exist local sub, {}", (Object)subscriptionGroupConfig.toString());
    }

    public synchronized void persist() {
        if (this.brokerController.getMessageStoreConfig().isRealTimePersistRocksDBConfig()) {
            this.rocksDBConfigManager.flushWAL();
        }
    }

    public synchronized void exportToJson() {
        log.info("RocksDBSubscriptionGroupManager export subscription group to json file");
        super.persist();
    }

    public String rocksdbConfigFilePath(String storePathRootDir, boolean useSingleRocksDBForAllConfigs) {
        if (StringUtils.isBlank((CharSequence)storePathRootDir)) {
            storePathRootDir = this.brokerController.getMessageStoreConfig().getStorePathRootDir();
        }
        Path rootPath = Paths.get(storePathRootDir, new String[0]);
        if (useSingleRocksDBForAllConfigs) {
            return rootPath.resolve("config").resolve("metadata").toString();
        }
        return rootPath.resolve("config").resolve("subscriptionGroups").toString();
    }

    @Override
    public String configFilePath() {
        return BrokerPathConfigHelper.getSubscriptionGroupPath(this.storePathRootDir);
    }

    @Override
    public DataVersion getDataVersion() {
        return this.rocksDBConfigManager.getKvDataVersion();
    }

    @Override
    public void updateDataVersion() {
        try {
            this.rocksDBConfigManager.updateKvDataVersion();
        }
        catch (Exception e) {
            log.error("update group config dataVersion error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void decodeForbidden(byte[] key, byte[] body) {
        String forbiddenGroupName = new String(key, RocksDBConfigManager.CHARSET);
        JSONObject jsonObject = JSON.parseObject((String)new String(body, RocksDBConfigManager.CHARSET));
        Set entries = jsonObject.entrySet();
        ConcurrentHashMap forbiddenGroup = new ConcurrentHashMap(entries.size());
        for (Map.Entry entry : entries) {
            forbiddenGroup.put(entry.getKey(), (Integer)entry.getValue());
        }
        this.getForbiddenTable().put(forbiddenGroupName, forbiddenGroup);
        log.info("load forbidden,{} value {}", (Object)forbiddenGroupName, (Object)((Object)forbiddenGroup).toString());
    }

    @Override
    public void updateForbidden(String group, String topic, int forbiddenIndex, boolean setOrClear) {
        try {
            super.updateForbidden(group, topic, forbiddenIndex, setOrClear);
            this.rocksDBConfigManager.put(FORBIDDEN_COLUMN_FAMILY_NAME, group, JSON.toJSONString(this.getForbiddenTable().get(group)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setForbidden(String group, String topic, int forbiddenIndex) {
        try {
            super.setForbidden(group, topic, forbiddenIndex);
            this.rocksDBConfigManager.put(FORBIDDEN_COLUMN_FAMILY_NAME, group, JSON.toJSONString(this.getForbiddenTable().get(group)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearForbidden(String group, String topic, int forbiddenIndex) {
        try {
            super.clearForbidden(group, topic, forbiddenIndex);
            this.rocksDBConfigManager.put(FORBIDDEN_COLUMN_FAMILY_NAME, group, JSON.toJSONString(this.getForbiddenTable().get(group)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFromSeparateRocksDBs() {
        block26: {
            String separateRocksDBPath = this.rocksdbConfigFilePath(this.storePathRootDir, false);
            if (!UtilAll.isPathExists((String)separateRocksDBPath)) {
                log.info("Separate RocksDB for subscription groups does not exist at {}, no migration needed", (Object)separateRocksDBPath);
                return;
            }
            log.info("Starting migration from separate RocksDB at {} to unified RocksDB", (Object)separateRocksDBPath);
            RocksDBConfigManager separateRocksDBConfigManager = null;
            try {
                long memTableFlushIntervalMs = this.brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs();
                CompressionType compressionType = CompressionType.getCompressionType((String)this.brokerController.getMessageStoreConfig().getRocksdbCompressionType());
                separateRocksDBConfigManager = new RocksDBConfigManager(separateRocksDBPath, memTableFlushIntervalMs, compressionType);
                if (!separateRocksDBConfigManager.init(true)) {
                    log.error("Failed to initialize separate RocksDB in read-only mode");
                    return;
                }
                if (!separateRocksDBConfigManager.loadDataVersion()) {
                    log.error("Failed to load data version from separate RocksDB");
                    return;
                }
                DataVersion separateDataVersion = separateRocksDBConfigManager.getKvDataVersion();
                DataVersion unifiedDataVersion = this.getDataVersion();
                log.info("Comparing data versions - Separate: {}, Unified: {}", (Object)separateDataVersion, (Object)unifiedDataVersion);
                if (separateDataVersion.getCounter().get() > unifiedDataVersion.getCounter().get()) {
                    log.info("Separate RocksDB has newer data, importing...");
                    boolean success = separateRocksDBConfigManager.loadData(this::importSubscriptionGroup);
                    if (success) {
                        try {
                            separateRocksDBConfigManager.configRocksDBStorage.iterate(FORBIDDEN_COLUMN_FAMILY_NAME, this::importForbidden);
                            log.info("Successfully imported subscription groups and forbidden data from separate RocksDB");
                            this.getDataVersion().assignNewOne(separateDataVersion);
                            this.getDataVersion().nextVersion();
                            this.updateDataVersion();
                            log.info("Updated unified data version to {}", (Object)this.getDataVersion());
                        }
                        catch (Exception e) {
                            log.error("Failed to import forbidden data from separate RocksDB", (Throwable)e);
                            success = false;
                        }
                    }
                    if (!success) {
                        log.error("Failed to import subscription groups or forbidden data from separate RocksDB");
                    }
                    break block26;
                }
                log.info("Unified RocksDB is already up-to-date, no migration needed");
            }
            catch (Exception e) {
                log.error("Error during migration from separate RocksDB", (Throwable)e);
            }
            finally {
                if (separateRocksDBConfigManager != null) {
                    try {
                        separateRocksDBConfigManager.stop();
                    }
                    catch (Exception e) {
                        log.warn("Error stopping separate RocksDB config manager", (Throwable)e);
                    }
                }
            }
        }
    }

    private void importSubscriptionGroup(byte[] key, byte[] body) {
        try {
            this.decodeSubscriptionGroup(key, body);
            this.rocksDBConfigManager.put(key, body);
        }
        catch (Exception e) {
            log.error("Error importing subscription group", (Throwable)e);
        }
    }

    private void importForbidden(byte[] key, byte[] body) {
        try {
            this.decodeForbidden(key, body);
            this.rocksDBConfigManager.put(FORBIDDEN_COLUMN_FAMILY_NAME, key, body);
        }
        catch (Exception e) {
            log.error("Error importing forbidden data", (Throwable)e);
        }
    }
}

