/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.attribute;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public enum TopicMessageType {
    UNSPECIFIED("UNSPECIFIED"),
    NORMAL("NORMAL"),
    FIFO("FIFO"),
    DELAY("DELAY"),
    TRANSACTION("TRANSACTION"),
    PRIORITY("PRIORITY"),
    MIXED("MIXED");

    private final String value;

    private TopicMessageType(String value) {
        this.value = value;
    }

    public static Set<String> topicMessageTypeSet() {
        return Sets.newHashSet((Object[])new String[]{TopicMessageType.UNSPECIFIED.value, TopicMessageType.NORMAL.value, TopicMessageType.FIFO.value, TopicMessageType.DELAY.value, TopicMessageType.TRANSACTION.value, TopicMessageType.PRIORITY.value, TopicMessageType.MIXED.value});
    }

    public String getValue() {
        return this.value;
    }

    public static TopicMessageType parseFromMessageProperty(Map<String, String> messageProperty) {
        if (Boolean.parseBoolean(messageProperty.get("TRAN_MSG"))) {
            return TRANSACTION;
        }
        if (messageProperty.get("DELAY") != null || messageProperty.get("TIMER_DELIVER_MS") != null || messageProperty.get("TIMER_DELAY_SEC") != null || messageProperty.get("TIMER_DELAY_MS") != null) {
            return DELAY;
        }
        if (messageProperty.get("__SHARDINGKEY") != null) {
            return FIFO;
        }
        if (messageProperty.get("_SYS_MSG_PRIORITY_") != null) {
            return PRIORITY;
        }
        return NORMAL;
    }

    public String getMetricsValue() {
        return this.value.toLowerCase();
    }
}

